/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail;

import java.io.InputStream;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.util.encoders.Base64;

public class ExtendedMimeMessage
extends MimeMessage {
    private static final ThreadLocal<SHA1Digest> SHA1_DIGEST = new ThreadLocal();
    private static final String MESSAGE_ID_HEADER = "Message-ID";
    private static final String TO_HEADER = "To";
    private static final String XMAIL_TYPE_HEADER = "X-MailType";
    private String uniqueMessageId;

    public ExtendedMimeMessage() {
        super((Session)null);
    }

    public ExtendedMimeMessage(Session session, InputStream is) throws MessagingException {
        super(session, is);
    }

    public ExtendedMimeMessage(MimeMessage source) throws MessagingException {
        super(source);
    }

    public static ExtendedMimeMessage wrap(MimeMessage message) {
        if (message instanceof ExtendedMimeMessage) {
            return (ExtendedMimeMessage)message;
        }
        try {
            return new ExtendedMimeMessage(message);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unexpected exception while wrapping a MimeMessage into an extended one", e);
        }
    }

    public boolean isEmpty() {
        return this.dh == null;
    }

    public void setType(String mailType) {
        try {
            this.addHeader(XMAIL_TYPE_HEADER, mailType);
        }
        catch (MessagingException e) {
            throw new RuntimeException(String.format("Failed to set Type header to [%s]", mailType), e);
        }
    }

    public String getType() {
        try {
            return this.getHeader(XMAIL_TYPE_HEADER, null);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Failed to get Type header", e);
        }
    }

    public void setMessageId(String messageId) {
        try {
            this.ensureSaved();
            this.setHeader(MESSAGE_ID_HEADER, messageId);
        }
        catch (MessagingException e) {
            throw new RuntimeException(String.format("Failed to set Message ID header to [%s]", messageId), e);
        }
    }

    public boolean ensureSaved() throws MessagingException {
        if (!this.saved) {
            this.saveChanges();
            return true;
        }
        return false;
    }

    public void setHeader(String name, String value) throws MessagingException {
        if (this.uniqueMessageId != null && MESSAGE_ID_HEADER.equals(name) || TO_HEADER.equals(name)) {
            this.uniqueMessageId = null;
        }
        super.setHeader(name, value);
    }

    public String getUniqueMessageId() {
        if (this.uniqueMessageId == null) {
            try {
                StringBuilder sb = new StringBuilder(this.getNotNullMessageId());
                String recipients = InternetAddress.toString((Address[])this.getAllRecipients());
                if (recipients != null) {
                    sb.append(':').append(recipients);
                }
                this.uniqueMessageId = this.digest(sb.toString());
            }
            catch (MessagingException e) {
                throw new RuntimeException("Unexpected exception while computing a unique id for a MimeMessage", e);
            }
        }
        return this.uniqueMessageId;
    }

    private String getNotNullMessageId() throws MessagingException {
        String messageId = this.getMessageID();
        if (messageId == null) {
            this.saveChanges();
            messageId = this.getMessageID();
        }
        return messageId;
    }

    private String digest(String data) {
        SHA1Digest digest = SHA1_DIGEST.get();
        if (digest == null) {
            digest = new SHA1Digest();
            SHA1_DIGEST.set(new SHA1Digest());
        }
        byte[] bytes = data.getBytes();
        digest.update(bytes, 0, bytes.length);
        byte[] dig = new byte[digest.getDigestSize()];
        digest.doFinal(dig, 0);
        return Base64.toBase64String((byte[])dig);
    }
}

