/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail;

import java.util.Iterator;
import org.xwiki.mail.MailState;
import org.xwiki.mail.MailStatus;
import org.xwiki.mail.MailStatusResult;

public final class MailStatusResultSerializer {
    private MailStatusResultSerializer() {
    }

    public static String serializeErrors(MailStatusResult statusResult) {
        String result;
        Iterator<MailStatus> statuses = statusResult.getByState(MailState.FAILED);
        if (statuses.hasNext()) {
            StringBuilder builder = new StringBuilder("Some messages have failed to be sent for the following reasons: [");
            while (statuses.hasNext()) {
                MailStatus status = statuses.next();
                builder.append('[');
                builder.append('[').append(status.getErrorSummary()).append(']').append(',');
                builder.append('[').append(status.getErrorDescription()).append(']');
                builder.append(']');
            }
            builder.append(']');
            result = builder.toString();
        } else {
            result = null;
        }
        return result;
    }
}

