/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.mail.internal.factory.template;

import java.util.List;

import org.xwiki.component.annotation.Role;

import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.doc.XWikiAttachment;

/**
 * Convert from {@link com.xpn.xwiki.api.Attachment} to {@link com.xpn.xwiki.doc.XWikiAttachment}.
 *
 * @version $Id: 3c8ef329082af2455f9dd3c13e3e957239d0a1c4 $
 * @since 6.1RC1
 */
@Role
public interface AttachmentConverter
{
    /**
     * @param attachments the {@link com.xpn.xwiki.api.Attachment} attachments to convert
     * @return the attachments converted to {@link com.xpn.xwiki.doc.XWikiAttachment}
     */
    List<Attachment> convert(List<XWikiAttachment> attachments);
}
