/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.mail.internal.thread;

import org.xwiki.component.annotation.Role;

/**
 * Runnable to regularly check for mails on a Queue, and for each mail try to send it.
 *
 * @version $Id: a32bca52480bebd9fe2ca33f787b8c531dfea49b $
 * @since 6.4
 */
@Role
public interface MailRunnable extends Runnable
{
    /**
     * Stop the processing to stop the thread.
     */
    void stopProcessing();
}
