/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.mail.internal.thread;

import java.util.concurrent.LinkedBlockingQueue;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.mail.MailSenderConfiguration;

/**
 * Handles all operations on the Prepare Mail Queue.
 *
 * @version $Id: 6377deda4db92be558e4b85a50d5d1231a284ff1 $
 * @since 6.4
 */
@Component
@Singleton
public class PrepareMailQueueManager extends AbstractMailQueueManager<PrepareMailQueueItem>
    implements MailQueueManager<PrepareMailQueueItem>
{
    @Inject
    private MailSenderConfiguration configuration;

    @Override
    public void initialize()
    {
        this.mailQueue = new LinkedBlockingQueue<>(this.configuration.getPrepareQueueCapacity());
    }
}
