/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.mail.Authenticator;
import javax.mail.Session;
import org.xwiki.component.annotation.Component;
import org.xwiki.mail.MailSenderConfiguration;
import org.xwiki.mail.SessionFactory;
import org.xwiki.mail.XWikiAuthenticator;

@Component
@Singleton
public class DefaultSessionFactory
implements SessionFactory {
    @Inject
    private MailSenderConfiguration configuration;

    public Session create(Map<String, String> additionProperties) {
        Properties properties = this.configuration.getAllProperties();
        for (Map.Entry<String, String> entry : additionProperties.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        Session session = this.configuration.usesAuthentication() ? Session.getInstance((Properties)properties, (Authenticator)new XWikiAuthenticator(this.configuration)) : Session.getInstance((Properties)properties);
        return session;
    }
}

