/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.lang.reflect.Type;
import javax.inject.Singleton;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import org.xwiki.component.annotation.Component;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;

@Component
@Singleton
public class RecipientConverter
extends AbstractConverter<Message.RecipientType> {
    protected <G extends Message.RecipientType> G convertToType(Type targetType, Object value) {
        Message.RecipientType recipientType;
        if (value == null) {
            return null;
        }
        String valueAsString = value.toString();
        if (valueAsString.equalsIgnoreCase("to")) {
            recipientType = Message.RecipientType.TO;
        } else if (valueAsString.equalsIgnoreCase("cc")) {
            recipientType = Message.RecipientType.CC;
        } else if (valueAsString.equalsIgnoreCase("bcc")) {
            recipientType = Message.RecipientType.BCC;
        } else if (valueAsString.equalsIgnoreCase("newsgroups")) {
            recipientType = MimeMessage.RecipientType.NEWSGROUPS;
        } else {
            throw new ConversionException(String.format("Cannot convert [%s] to [%s]", value, Message.RecipientType.class.getName()));
        }
        return (G)recipientType;
    }
}

