/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory.attachment;

import com.xpn.xwiki.api.Attachment;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.io.FileUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.environment.Environment;
import org.xwiki.mail.internal.factory.AbstractMimeBodyPartFactory;

@Component
@Named(value="xwiki/attachment")
@Singleton
public class AttachmentMimeBodyPartFactory
extends AbstractMimeBodyPartFactory<Attachment>
implements Initializable {
    public static final String TMP_ATTACHMENT_LOCATION_FILE_HEADER = "X-TmpFile";
    @Inject
    private Environment environment;
    private File temporaryDirectory;

    public void initialize() {
        this.temporaryDirectory = new File(this.environment.getTemporaryDirectory(), "mail");
        this.temporaryDirectory.mkdirs();
    }

    public MimeBodyPart create(Attachment attachment, Map<String, Object> parameters) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        DataSource source = this.createTemporaryAttachmentDataSource(attachment, attachmentPart);
        attachmentPart.setDataHandler(new DataHandler(source));
        attachmentPart.setHeader("Content-Type", attachment.getMimeType());
        attachmentPart.setHeader("Content-ID", "<" + attachment.getFilename() + ">");
        attachmentPart.setFileName(attachment.getFilename());
        this.addHeaders(attachmentPart, parameters);
        return attachmentPart;
    }

    private DataSource createTemporaryAttachmentDataSource(Attachment attachment, MimeBodyPart attachmentPart) throws MessagingException {
        File temporaryAttachmentFile;
        try {
            temporaryAttachmentFile = File.createTempFile("attachment", ".tmp", this.temporaryDirectory);
            FileUtils.copyInputStreamToFile((InputStream)attachment.getContentInputStream(), (File)temporaryAttachmentFile);
            attachmentPart.setHeader(TMP_ATTACHMENT_LOCATION_FILE_HEADER, temporaryAttachmentFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new MessagingException(String.format("Failed to save attachment [%s] to the file system", attachment.getFilename()), e);
        }
        return new FileDataSource(temporaryAttachmentFile);
    }
}

