/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.thread;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.mail.internal.thread.MailRunnable;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="MailSenderInitializationEventListener")
@Singleton
public class MailSenderInitializerListener
implements EventListener,
Disposable {
    public static final String LISTENER_NAME = "MailSenderInitializationEventListener";
    private static final List<Event> EVENTS = new ArrayList<ApplicationReadyEvent>(Arrays.asList(new ApplicationReadyEvent()));
    private static final Logger SHUTDOWN_LOGGER = LoggerFactory.getLogger((String)"org.xwiki.shutdown");
    @Inject
    @Named(value="prepare")
    private MailRunnable prepareMailRunnable;
    @Inject
    @Named(value="send")
    private MailRunnable sendMailRunnable;
    private Thread prepareMailThread;
    private Thread sendMailThread;

    public String getName() {
        return LISTENER_NAME;
    }

    public List<Event> getEvents() {
        return EVENTS;
    }

    public void onEvent(Event event, Object o, Object o1) {
        this.prepareMailThread = new Thread(this.prepareMailRunnable);
        this.prepareMailThread.setName("Mail Prepare Thread");
        this.prepareMailThread.setDaemon(true);
        this.prepareMailThread.start();
        this.sendMailThread = new Thread(this.sendMailRunnable);
        this.sendMailThread.setName("Mail Sender Thread");
        this.sendMailThread.setDaemon(true);
        this.sendMailThread.start();
    }

    private void stopMailThreads() throws InterruptedException {
        if (this.sendMailThread != null) {
            this.sendMailRunnable.stopProcessing();
            this.sendMailThread.interrupt();
            this.sendMailThread.join();
            SHUTDOWN_LOGGER.debug(String.format("Mail Prepare Thread has been stopped", new Object[0]));
        }
        if (this.prepareMailThread != null) {
            this.prepareMailRunnable.stopProcessing();
            this.prepareMailThread.interrupt();
            this.prepareMailThread.join();
            SHUTDOWN_LOGGER.debug(String.format("Mail Sender Thread has been stopped", new Object[0]));
        }
    }

    public void dispose() throws ComponentLifecycleException {
        try {
            this.stopMailThreads();
        }
        catch (InterruptedException e) {
            SHUTDOWN_LOGGER.debug("Mail threads shutdown has been interruped", (Throwable)e);
        }
    }
}

