/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import com.xpn.xwiki.api.Attachment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.environment.Environment;
import org.xwiki.mail.internal.AbstractMimeBodyPartFactory;

@Component
@Named(value="xwiki/attachment")
@Singleton
public class AttachmentMimeBodyPartFactory
extends AbstractMimeBodyPartFactory<Attachment>
implements Initializable {
    private static final String HEADERS_PARAMETER_KEY = "headers";
    @Inject
    private Environment environment;
    @Inject
    private Logger logger;
    private File temporaryDirectory;

    public void initialize() throws InitializationException {
        this.temporaryDirectory = new File(this.environment.getTemporaryDirectory(), "mail");
        this.temporaryDirectory.mkdirs();
    }

    public MimeBodyPart create(Attachment attachment, Map<String, Object> parameters) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart();
        DataSource source = this.createTemporaryAttachmentDataSource(attachment);
        attachmentPart.setDataHandler(new DataHandler(source));
        attachmentPart.setHeader("Content-Type", attachment.getMimeType());
        attachmentPart.setHeader("Content-ID", "<" + attachment.getFilename() + ">");
        attachmentPart.setFileName(source.getName());
        this.addHeaders(attachmentPart, parameters);
        return attachmentPart;
    }

    private DataSource createTemporaryAttachmentDataSource(Attachment attachment) throws MessagingException {
        File temporaryAttachmentFile;
        FileOutputStream fos = null;
        try {
            temporaryAttachmentFile = File.createTempFile("attachment", ".tmp", this.temporaryDirectory);
            temporaryAttachmentFile.deleteOnExit();
            fos = new FileOutputStream(temporaryAttachmentFile);
            fos.write(attachment.getContent());
        }
        catch (Exception e) {
            throw new MessagingException(String.format("Failed to save attachment [%s] to the file system", attachment.getFilename()), e);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed to close the temporary file attachment when sending an email. Root reason: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return new FileDataSource(temporaryAttachmentFile);
    }
}

