/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.io.ByteArrayInputStream;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.mail.MailSenderConfiguration;

@Component
@Singleton
public class DefaultMailSenderConfiguration
implements MailSenderConfiguration {
    public static final String JAVAMAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String JAVAMAIL_SMTP_HOST = "mail.smtp.host";
    public static final String JAVAMAIL_SMTP_PORT = "mail.smtp.port";
    public static final String JAVAMAIL_SMTP_USERNAME = "mail.smtp.user";
    public static final String JAVAMAIL_SMTP_FROM = "mail.smtp.from";
    public static final String JAVAMAIL_SMTP_AUTH = "mail.smtp.auth";
    private static final String PREFIX = "mail.sender.";
    private static final int DEFAULT_PORT = 25;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="documents")
    private ConfigurationSource documentsSource;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource xwikiPropertiesSource;

    public String getHost() {
        return (String)this.documentsSource.getProperty("smtp_server", this.xwikiPropertiesSource.getProperty("mail.sender.host", (Object)"localhost"));
    }

    public int getPort() {
        int port;
        String portAsString = (String)this.documentsSource.getProperty("smtp_port");
        if (!StringUtils.isEmpty((CharSequence)portAsString)) {
            try {
                port = Integer.parseInt(portAsString);
            }
            catch (NumberFormatException e) {
                port = 25;
            }
        } else {
            port = (Integer)this.xwikiPropertiesSource.getProperty("mail.sender.port", (Object)25);
        }
        return port;
    }

    public String getUsername() {
        return (String)this.documentsSource.getProperty("smtp_server_username", this.xwikiPropertiesSource.getProperty("mail.sender.username", String.class));
    }

    public String getPassword() {
        return (String)this.documentsSource.getProperty("smtp_server_password", this.xwikiPropertiesSource.getProperty("mail.sender.password", String.class));
    }

    public String getFromAddress() {
        return (String)this.documentsSource.getProperty("admin_email", this.xwikiPropertiesSource.getProperty("mail.sender.from", String.class));
    }

    public Properties getAdditionalProperties() {
        Properties properties;
        String extraPropertiesAsString = (String)this.documentsSource.getProperty("javamail_extra_props");
        if (StringUtils.isEmpty((CharSequence)extraPropertiesAsString)) {
            properties = (Properties)this.xwikiPropertiesSource.getProperty("mail.sender.properties", Properties.class);
        } else {
            ByteArrayInputStream is = new ByteArrayInputStream(extraPropertiesAsString.getBytes());
            properties = new Properties();
            try {
                properties.load(is);
            }
            catch (Exception e) {
                this.logger.warn("Error while parsing mail properties [{}]. Root cause [{}]. Ignoring configuration...", (Object)extraPropertiesAsString, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return properties;
    }

    public Properties getAllProperties() {
        Properties properties = new Properties();
        this.addProperty(properties, JAVAMAIL_TRANSPORT_PROTOCOL, "smtp");
        this.addProperty(properties, JAVAMAIL_SMTP_HOST, this.getHost());
        this.addProperty(properties, JAVAMAIL_SMTP_USERNAME, this.getUsername());
        this.addProperty(properties, JAVAMAIL_SMTP_FROM, this.getFromAddress());
        this.addProperty(properties, JAVAMAIL_SMTP_PORT, Integer.toString(this.getPort()));
        if (this.usesAuthentication()) {
            properties.put(JAVAMAIL_SMTP_AUTH, "true");
        }
        properties.putAll((Map<?, ?>)this.getAdditionalProperties());
        return properties;
    }

    private void addProperty(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }

    public boolean usesAuthentication() {
        return !StringUtils.isEmpty((CharSequence)this.getUsername()) && !StringUtils.isEmpty((CharSequence)this.getPassword());
    }

    public String getScriptServicePermissionCheckerHint() {
        return (String)this.xwikiPropertiesSource.getProperty("mail.sender.scriptServiceCheckerHint", (Object)"programmingrights");
    }
}

