/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.util.Queue;
import javax.inject.Inject;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.mail.MailResultListener;
import org.xwiki.mail.internal.MailSenderQueueItem;
import org.xwiki.mail.internal.MailSenderThread;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultMailSenderThread
extends Thread
implements MailSenderThread {
    @Inject
    private Logger logger;
    private Queue<MailSenderQueueItem> mailQueue;
    private volatile boolean shouldStop;
    private Transport currentTransport;
    private Session currentSession;
    private int count;

    @Override
    public void startProcessing(Queue<MailSenderQueueItem> mailQueue) {
        this.mailQueue = mailQueue;
        this.start();
    }

    @Override
    public void run(Queue<MailSenderQueueItem> mailQueue) {
        this.mailQueue = mailQueue;
        this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            do {
                if (!this.mailQueue.isEmpty()) {
                    MailSenderQueueItem mailItem = this.mailQueue.peek();
                    try {
                        this.sendMail(mailItem);
                    }
                    finally {
                        this.mailQueue.remove(mailItem);
                    }
                }
                try {
                    DefaultMailSenderThread.sleep(100L);
                }
                catch (Exception e) {
                    this.logger.debug("Mail Sender Thread was forcefully stopped", (Throwable)e);
                    break;
                }
            } while (!this.shouldStop);
        }
        finally {
            this.closeTransport();
        }
    }

    @Override
    public void stopProcessing() {
        this.shouldStop = true;
        this.interrupt();
    }

    protected void sendMail(MailSenderQueueItem item) {
        block6: {
            MimeMessage message = item.getMessage();
            MailResultListener listener = item.getListener();
            try {
                if (item.getSession() != this.currentSession || this.count % 100 == 0) {
                    this.closeTransport();
                    this.currentSession = item.getSession();
                    this.currentTransport = this.currentSession.getTransport("smtp");
                    this.currentTransport.connect();
                } else if (!this.currentTransport.isConnected()) {
                    this.currentTransport.connect();
                }
                this.currentTransport.sendMessage((Message)message, message.getAllRecipients());
                ++this.count;
                if (listener != null) {
                    listener.onSuccess(message);
                }
            }
            catch (Exception e) {
                if (listener == null) break block6;
                listener.onError(message, e);
            }
        }
    }

    private void closeTransport() {
        if (this.currentTransport != null) {
            try {
                this.currentTransport.close();
            }
            catch (MessagingException e) {
                this.logger.warn("Failed to close JavaMail Transport connection. Reason [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }
}

