/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.mail.internal.AbstractMimeBodyPartFactory;

@Component
@Singleton
public class DefaultMimeBodyPartFactory
extends AbstractMimeBodyPartFactory<String> {
    @Inject
    private Logger logger;

    public MimeBodyPart create(String content, Map<String, Object> parameters) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Object)content, "text/plain; charset=" + StandardCharsets.UTF_8.name());
        bodyPart.setHeader("Content-Type", this.getMimetype(parameters));
        this.addHeaders(bodyPart, parameters);
        return bodyPart;
    }

    protected String getMimetype(Map<String, Object> parameters) {
        String mimeType = (String)parameters.get("mimetype");
        if (StringUtils.isEmpty((CharSequence)mimeType)) {
            mimeType = "text/plain";
        }
        return mimeType;
    }
}

