/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.template;

import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.mail.MimeBodyPartFactory;
import org.xwiki.mail.MimeMessageFactory;
import org.xwiki.mail.internal.ExtendedMimeMessage;
import org.xwiki.mail.internal.template.MailTemplateManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.properties.ConverterManager;

public abstract class AbstractTemplateMimeMessageFactory
implements MimeMessageFactory<DocumentReference> {
    @Inject
    private ConverterManager converterManager;

    protected abstract MailTemplateManager getTemplateManager();

    protected abstract MimeBodyPartFactory<DocumentReference> getMimeBodyPartFactory();

    public MimeMessage createMessage(Session session, DocumentReference templateReference, Map<String, Object> parameters) throws MessagingException {
        ExtendedMimeMessage message = new ExtendedMimeMessage(session);
        Address from = (Address)this.converterManager.convert(Address.class, parameters.get("from"));
        if (from != null) {
            message.setFrom(from);
        }
        this.setRecipient(message, Message.RecipientType.TO, parameters.get("to"));
        this.setRecipient(message, Message.RecipientType.CC, parameters.get("cc"));
        this.setRecipient(message, Message.RecipientType.BCC, parameters.get("bcc"));
        Map velocityVariables = (Map)parameters.get("velocityVariables");
        String language = (String)parameters.get("language");
        Locale locale = LocaleUtils.toLocale((String)language);
        String subject = this.getTemplateManager().evaluate(templateReference, "subject", velocityVariables, locale);
        message.setSubject(subject);
        MimeMultipart multipart = new MimeMultipart("mixed");
        multipart.addBodyPart((BodyPart)this.getMimeBodyPartFactory().create((Object)templateReference, parameters));
        message.setContent((Multipart)multipart);
        return message;
    }

    private void setRecipient(MimeMessage message, Message.RecipientType type, Object value) throws MessagingException {
        Address[] addresses = (Address[])this.converterManager.convert(Address[].class, value);
        if (addresses != null) {
            message.setRecipients(type, addresses);
        }
    }
}

