/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.script;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.context.Execution;
import org.xwiki.mail.MailResultListener;
import org.xwiki.mail.MailSender;
import org.xwiki.mail.MailSenderConfiguration;
import org.xwiki.mail.MimeBodyPartFactory;
import org.xwiki.mail.internal.DefaultMailResultListener;
import org.xwiki.mail.internal.ExtendedMimeMessage;
import org.xwiki.mail.script.ScriptServicePermissionChecker;
import org.xwiki.stability.Unstable;

@Unstable
public class MimeMessageWrapper {
    private ComponentManager componentManager;
    private MailSender mailSender;
    private Execution execution;
    private MailSenderConfiguration configuration;
    private DefaultMailResultListener listener;
    private Session session;
    private ExtendedMimeMessage message;

    MimeMessageWrapper(ExtendedMimeMessage message, Session session, MailSender mailSender, Execution execution, MailSenderConfiguration configuration, ComponentManager componentManager) {
        this.message = message;
        this.session = session;
        this.mailSender = mailSender;
        this.execution = execution;
        this.configuration = configuration;
        this.componentManager = componentManager;
        this.listener = new DefaultMailResultListener();
    }

    public ExtendedMimeMessage getMessage() {
        return this.message;
    }

    public void addPart(String mimeType, Object content) {
        this.addPart(mimeType, content, Collections.emptyMap());
    }

    public void addPart(String mimeType, Object content, Map<String, Object> parameters) {
        try {
            MimeBodyPartFactory factory = this.getBodyPartFactory(mimeType, content.getClass());
            HashMap<String, Object> enhancedParameters = new HashMap<String, Object>();
            enhancedParameters.put("mimetype", mimeType);
            enhancedParameters.putAll(parameters);
            Multipart multipart = this.getMultipart();
            multipart.addBodyPart((BodyPart)factory.create(content, enhancedParameters));
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    public void send() {
        try {
            this.checkPermissions();
            this.mailSender.send((MimeMessage)this.getMessage(), this.session);
        }
        catch (MessagingException e) {
            this.setError((Exception)((Object)e));
        }
    }

    public void sendAsynchronously() {
        try {
            this.checkPermissions();
        }
        catch (MessagingException e) {
            this.setError((Exception)((Object)e));
            return;
        }
        this.mailSender.sendAsynchronously((MimeMessage)this.getMessage(), this.session, (MailResultListener)this.listener);
    }

    public void setSubject(String subject) {
        try {
            this.getMessage().setSubject(subject);
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    public void setFrom(Address address) {
        try {
            this.getMessage().setFrom(address);
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    public void addRecipients(Message.RecipientType type, Address[] addresses) {
        try {
            this.getMessage().addRecipients(type, addresses);
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    public void addRecipient(Message.RecipientType type, Address address) {
        try {
            this.getMessage().addRecipient(type, address);
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    public void addHeader(String name, String value) {
        try {
            this.getMessage().addHeader(name, value);
        }
        catch (Exception e) {
            this.setError(e);
        }
    }

    private void setError(Exception e) {
        this.execution.getContext().setProperty("scriptservice.mailsender.error", (Object)e);
    }

    public void waitTillSent(long timeout) {
        this.mailSender.waitTillSent(timeout);
    }

    public BlockingQueue<Exception> getErrors() {
        return this.listener.getExceptionQueue();
    }

    private MimeBodyPartFactory getBodyPartFactory(String mimeType, Class contentClass) throws MessagingException {
        MimeBodyPartFactory factory;
        try {
            factory = this.getSpecificBodyPartFactory(mimeType, contentClass);
        }
        catch (ComponentLookupException e) {
            if (String.class.isAssignableFrom(contentClass)) {
                try {
                    factory = (MimeBodyPartFactory)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, MimeBodyPartFactory.class, new Type[]{String.class}));
                }
                catch (ComponentLookupException eee) {
                    throw new MessagingException(String.format("Failed to find default Mime Body Part Factory for mime type [%s] and Content type [%s]", mimeType, contentClass.getName()), (Exception)((Object)e));
                }
            }
            throw new MessagingException(String.format("Failed to a Mime Body Part Factory matching the mime type [%s] and the Content type [%s]", mimeType, contentClass.getName()), (Exception)((Object)e));
        }
        return factory;
    }

    private MimeBodyPartFactory getSpecificBodyPartFactory(String mimeType, Class contentClass) throws ComponentLookupException {
        MimeBodyPartFactory factory;
        try {
            factory = (MimeBodyPartFactory)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, MimeBodyPartFactory.class, new Type[]{contentClass}), String.format("%s/secure", mimeType));
        }
        catch (ComponentLookupException e) {
            factory = (MimeBodyPartFactory)this.componentManager.getInstance((Type)new DefaultParameterizedType(null, MimeBodyPartFactory.class, new Type[]{contentClass}), mimeType);
        }
        return factory;
    }

    private Multipart getMultipart() throws MessagingException, IOException {
        MimeMultipart multipart;
        ExtendedMimeMessage mimeMessage = this.getMessage();
        if (mimeMessage.isEmpty()) {
            multipart = new MimeMultipart("mixed");
            mimeMessage.setContent((Multipart)multipart);
        } else {
            Object contentObject = mimeMessage.getContent();
            if (contentObject instanceof Multipart) {
                multipart = (Multipart)contentObject;
            } else {
                throw new MessagingException(String.format("Unknown mail content type [%s]: [%s]", contentObject.getClass().getName(), contentObject));
            }
        }
        return multipart;
    }

    private void checkPermissions() throws MessagingException {
        ScriptServicePermissionChecker checker;
        String hint = this.configuration.getScriptServicePermissionCheckerHint();
        try {
            checker = (ScriptServicePermissionChecker)this.componentManager.getInstance(ScriptServicePermissionChecker.class, hint);
        }
        catch (ComponentLookupException e) {
            throw new MessagingException(String.format("Failed to locate Permission Checker [%s]. The mail has not been sent.", hint), (Exception)((Object)e));
        }
        try {
            checker.check((MimeMessage)this.getMessage());
        }
        catch (MessagingException e) {
            throw new MessagingException(String.format("Not authorized to send mail with subject [%s], using Permission Checker [%s]. The mail has not been sent.", this.getMessage().getSubject(), hint), (Exception)((Object)e));
        }
    }
}

