/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MailListener;

public abstract class AbstractMailListener
implements MailListener {
    @Inject
    protected Logger logger;
    private String batchId;

    protected String getBatchId() {
        return this.batchId;
    }

    public void onPrepareBegin(String batchId, Map<String, Object> parameters) {
        if (this.batchId != null) {
            throw new RuntimeException("A mail listener cannot be reused. This listener has been used for batch [" + this.batchId + "] and is now called for batch [" + batchId + "].");
        }
        this.logger.debug("Mail preparation begins for batch [{}].", (Object)batchId);
        this.batchId = batchId;
    }

    public void onPrepareMessageSuccess(ExtendedMimeMessage message, Map<String, Object> parameters) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mail preparation succeed for message [{}] of batch [{}].", (Object)message.getUniqueMessageId(), (Object)this.batchId);
        }
    }

    public void onPrepareMessageError(ExtendedMimeMessage message, Exception exception, Map<String, Object> parameters) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mail preparation failed for message [{}] of batch [{}].", new Object[]{message.getUniqueMessageId(), this.batchId, exception});
        }
    }

    public void onPrepareFatalError(Exception exception, Map<String, Object> parameters) {
        this.logger.debug("Failure during preparation phase of thread [" + this.batchId + "]");
    }

    public void onPrepareEnd(Map<String, Object> parameters) {
        this.logger.debug("Mail preparation ended for batch [{}].", (Object)this.batchId);
    }

    public void onSendMessageSuccess(ExtendedMimeMessage message, Map<String, Object> parameters) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mail sent successfully for message [{}] of batch [{}].", (Object)message.getUniqueMessageId(), (Object)this.batchId);
        }
    }

    public void onSendMessageError(ExtendedMimeMessage message, Exception exception, Map<String, Object> parameters) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Mail sending failed for message [{}] of batch [{}].", new Object[]{message.getUniqueMessageId(), this.batchId, exception});
        }
    }

    public void onSendMessageFatalError(String uniqueMessageId, Exception exception, Map<String, Object> parameters) {
        this.logger.debug("Mail loading failed for message [{}] of batch [{}].", new Object[]{uniqueMessageId, this.batchId, exception});
    }
}

