/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory.group;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import java.lang.reflect.Type;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.Execution;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MimeMessageFactory;
import org.xwiki.mail.internal.factory.AbstractMessageIterator;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;

@Deprecated
public class GroupMimeMessageIterator
extends AbstractMessageIterator {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupMimeMessageIterator.class);
    private static final String USER_SPACE = "XWiki";
    private static final EntityReference GROUPS_CLASS = new EntityReference("XWikiGroups", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    private DocumentAccessBridge documentAccessBridge;
    private DocumentReferenceResolver<String> stringResolver;
    private DocumentReference groupReference;
    private ComponentManager componentManager;

    public GroupMimeMessageIterator(DocumentReference groupReference, MimeMessageFactory<MimeMessage> factory, Map<String, Object> parameters, ComponentManager componentManager) throws MessagingException {
        this.factory = factory;
        this.parameters = parameters;
        this.groupReference = groupReference;
        this.componentManager = componentManager;
        XWikiContext context = this.getXWikiContext();
        try {
            this.iteratorSize = context.getWiki().getDocument(groupReference, context).getXObjects(GROUPS_CLASS).size();
        }
        catch (XWikiException e) {
            throw new MessagingException(String.format("Failed to find number of [%s] objects in group Document [%s]", GROUPS_CLASS, groupReference), (Exception)((Object)e));
        }
        this.documentAccessBridge = this.getAccessBridge();
        this.stringResolver = this.getResolver();
    }

    @Override
    protected ExtendedMimeMessage createMessageInternal() throws MessagingException {
        ExtendedMimeMessage mimeMessage;
        DocumentReference groupsClassReference = this.stringResolver.resolve((Object)"XWiki.XWikiGroups", new Object[0]);
        String userFullName = this.documentAccessBridge.getProperty(this.groupReference, groupsClassReference, this.position, "member").toString();
        DocumentReference userReference = this.stringResolver.resolve((Object)userFullName, new Object[0]);
        Object emailObject = this.documentAccessBridge.getProperty(userReference, new DocumentReference(userReference.getWikiReference().getName(), USER_SPACE, "XWikiUsers"), "email");
        if (emailObject != null) {
            String email = emailObject.toString();
            Map parameters = (Map)this.parameters.get("parameters");
            mimeMessage = ExtendedMimeMessage.wrap((MimeMessage)((MimeMessage)this.factory.createMessage(this.parameters.get("source"), parameters)));
            mimeMessage.addRecipients(Message.RecipientType.TO, email);
        } else {
            this.getLogger().warn("User [{}] has no email defined. Email has not been sent to that user.", (Object)userReference);
            mimeMessage = null;
        }
        return mimeMessage;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    private DocumentAccessBridge getAccessBridge() throws MessagingException {
        DocumentAccessBridge accessBridge;
        try {
            accessBridge = (DocumentAccessBridge)this.componentManager.getInstance(DocumentAccessBridge.class);
        }
        catch (ComponentLookupException e) {
            throw new MessagingException("Failed to find default Document bridge ", (Exception)((Object)e));
        }
        return accessBridge;
    }

    private XWikiContext getXWikiContext() throws MessagingException {
        XWikiContext xWikiContext;
        try {
            Execution execution = (Execution)this.componentManager.getInstance(Execution.class);
            xWikiContext = (XWikiContext)execution.getContext().getProperty("xwikicontext");
        }
        catch (ComponentLookupException e) {
            throw new MessagingException("Failed to find default Execution context", (Exception)((Object)e));
        }
        return xWikiContext;
    }

    private DocumentReferenceResolver<String> getResolver() throws MessagingException {
        DocumentReferenceResolver resolver;
        try {
            resolver = (DocumentReferenceResolver)this.componentManager.getInstance((Type)DocumentReferenceResolver.TYPE_STRING, "current");
        }
        catch (ComponentLookupException e) {
            throw new MessagingException("Failed to find default Document resolver", (Exception)((Object)e));
        }
        return resolver;
    }
}

