/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory.html;

import com.xpn.xwiki.api.Attachment;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.component.annotation.Component;
import org.xwiki.mail.MimeBodyPartFactory;
import org.xwiki.mail.internal.factory.AbstractMimeBodyPartFactory;

@Component
@Named(value="text/html")
@Singleton
public class HTMLMimeBodyPartFactory
extends AbstractMimeBodyPartFactory<String> {
    private static final Pattern CID_PATTERN = Pattern.compile("src=('|\")cid:([^'\"]*)('|\")", 10);
    private static final String TEXT_HTML_CONTENT_TYPE = "text/html; charset=" + StandardCharsets.UTF_8.name();
    @Inject
    @Named(value="xwiki/attachment")
    private MimeBodyPartFactory<Attachment> attachmentPartFactory;
    @Inject
    private MimeBodyPartFactory<String> defaultPartFactory;

    public MimeBodyPart create(String content, Map<String, Object> parameters) throws MessagingException {
        MimeBodyPart htmlBodyPart;
        List allAttachments = (List)parameters.get("attachments");
        Pair<List<Attachment>, List<Attachment>> attachmentPairs = this.separateAttachments(content, allAttachments);
        List embeddedImageAttachments = (List)attachmentPairs.getLeft();
        List normalAttachments = (List)attachmentPairs.getRight();
        if (!embeddedImageAttachments.isEmpty()) {
            htmlBodyPart = new MimeBodyPart();
            htmlBodyPart.setContent((Multipart)this.createHTMLMultipart(content, embeddedImageAttachments));
        } else {
            htmlBodyPart = this.createHTMLBodyPart(content, false);
        }
        String alternativeText = (String)parameters.get("alternate");
        MimeBodyPart resultBodyPart = alternativeText != null ? this.createAlternativePart(htmlBodyPart, this.defaultPartFactory.create((Object)alternativeText, Collections.emptyMap())) : htmlBodyPart;
        if (!normalAttachments.isEmpty()) {
            MimeMultipart multipart = new MimeMultipart("mixed");
            multipart.addBodyPart((BodyPart)resultBodyPart);
            this.handleAttachments(multipart, normalAttachments);
            resultBodyPart = new MimeBodyPart();
            resultBodyPart.setContent((Multipart)multipart);
        }
        this.addHeaders(resultBodyPart, parameters);
        return resultBodyPart;
    }

    private void handleAttachments(MimeMultipart multipart, List<Attachment> attachments) throws MessagingException {
        for (Attachment attachment : attachments) {
            multipart.addBodyPart((BodyPart)this.attachmentPartFactory.create((Object)attachment, Collections.emptyMap()));
        }
    }

    private MimeBodyPart createAlternativePart(MimeBodyPart htmlBodyPart, MimeBodyPart textBodyPart) throws MessagingException {
        MimeMultipart alternativeMultiPart = new MimeMultipart("alternative");
        alternativeMultiPart.addBodyPart((BodyPart)textBodyPart);
        alternativeMultiPart.addBodyPart((BodyPart)htmlBodyPart);
        MimeBodyPart alternativePartWrapper = new MimeBodyPart();
        alternativePartWrapper.setContent((Multipart)alternativeMultiPart);
        return alternativePartWrapper;
    }

    private MimeMultipart createHTMLMultipart(String content, List<Attachment> embeddedImages) throws MessagingException {
        MimeMultipart htmlMultipart = new MimeMultipart("related");
        htmlMultipart.addBodyPart((BodyPart)this.createHTMLBodyPart(content, true));
        this.handleAttachments(htmlMultipart, embeddedImages);
        return htmlMultipart;
    }

    private MimeBodyPart createHTMLBodyPart(String content, boolean hasAttachments) throws MessagingException {
        MimeBodyPart htmlPart = new MimeBodyPart();
        htmlPart.setContent((Object)content, TEXT_HTML_CONTENT_TYPE);
        htmlPart.setHeader("Content-Type", TEXT_HTML_CONTENT_TYPE);
        if (hasAttachments) {
            htmlPart.setHeader("Content-Disposition", "inline");
            htmlPart.setHeader("Content-Transfer-Encoding", "quoted-printable");
        }
        return htmlPart;
    }

    private Pair<List<Attachment>, List<Attachment>> separateAttachments(String content, List<Attachment> attachments) {
        if (attachments == null) {
            return new ImmutablePair(Collections.emptyList(), Collections.emptyList());
        }
        ArrayList<Attachment> normalAttachments = new ArrayList<Attachment>(attachments);
        Matcher matcher = CID_PATTERN.matcher(content);
        ArrayList<String> embeddedImageNames = new ArrayList<String>();
        while (matcher.find()) {
            embeddedImageNames.add(matcher.group(2));
        }
        ArrayList<Attachment> embeddedImageAttachments = new ArrayList<Attachment>();
        for (Attachment attachment : attachments) {
            if (!embeddedImageNames.contains(attachment.getFilename())) continue;
            embeddedImageAttachments.add(attachment);
            normalAttachments.remove(attachment);
        }
        return new ImmutablePair(embeddedImageAttachments, normalAttachments);
    }
}

