/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory.template;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.mail.MessagingException;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.mail.internal.factory.template.MailTemplateManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="secure")
@Singleton
public class SecureMailTemplateManager
implements MailTemplateManager {
    @Inject
    private MailTemplateManager templateManager;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private DocumentAccessBridge documentBridge;

    @Override
    public String evaluate(DocumentReference templateReference, String property, Map<String, Object> velocityVariables, Object localeValue) throws MessagingException {
        if (!this.authorizationManager.hasAccess(Right.VIEW, this.documentBridge.getCurrentUserReference(), (EntityReference)templateReference)) {
            throw new MessagingException(String.format("Current user [%s] has no permission to view Mail Template Document [%s]", this.documentBridge.getCurrentUserReference(), templateReference));
        }
        return this.templateManager.evaluate(templateReference, property, velocityVariables, localeValue);
    }

    @Override
    public String evaluate(DocumentReference documentReference, String property, Map<String, Object> velocityVariables) throws MessagingException {
        return this.evaluate(documentReference, property, velocityVariables, null);
    }
}

