/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory.usersandgroups;

import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.mail.MimeMessageFactory;
import org.xwiki.mail.internal.factory.AbstractIteratorMimeMessageFactory;
import org.xwiki.mail.internal.factory.usersandgroups.UsersAndGroupsMimeMessageIterator;
import org.xwiki.model.reference.DocumentReferenceResolver;

@Component
@Named(value="usersandgroups")
@Singleton
public class UsersAndGroupsMimeMessageFactory
extends AbstractIteratorMimeMessageFactory {
    private static final String HINT = "hint";
    private static final String SOURCE = "source";
    @Inject
    @Named(value="explicit")
    private DocumentReferenceResolver<String> explicitDocumentReferenceResolver;
    @Inject
    private Execution execution;

    public Iterator<MimeMessage> createMessage(Object sourceObject, Map<String, Object> parameters) throws MessagingException {
        Map source = this.getTypedSource(sourceObject, Map.class);
        this.validateParameters(parameters, HINT, SOURCE);
        String factoryHint = (String)parameters.get(HINT);
        MimeMessageFactory factory = this.getInternalMimeMessageFactory(factoryHint);
        UsersAndGroupsMimeMessageIterator iterator = new UsersAndGroupsMimeMessageIterator(source, (MimeMessageFactory<MimeMessage>)factory, parameters, this.explicitDocumentReferenceResolver, this.execution);
        return iterator;
    }
}

