/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.mailsender;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.XWiki;
import com.xpn.xwiki.plugin.PluginApi;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.mailsender.Mail;
import com.xpn.xwiki.plugin.mailsender.MailConfiguration;
import com.xpn.xwiki.plugin.mailsender.MailSender;
import com.xpn.xwiki.plugin.mailsender.MailSenderPlugin;
import java.util.List;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailSenderPluginApi
extends PluginApi<MailSenderPlugin>
implements MailSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailSenderPluginApi.class);

    public MailSenderPluginApi(MailSenderPlugin plugin, XWikiContext context) {
        super((XWikiPluginInterface)plugin, context);
    }

    @Override
    public int sendHtmlMessage(String from, String to, String cc, String bcc, String subject, String body, String alternative, List<Attachment> attachments) {
        Mail email = new Mail();
        email.setSubject(subject);
        email.setFrom(from);
        email.setTo(to);
        email.setCc(cc);
        email.setBcc(bcc);
        email.setTextPart(alternative);
        email.setHtmlPart(body);
        email.setAttachments(attachments);
        return this.sendMail(email);
    }

    @Override
    public int sendTextMessage(String from, String to, String subject, String message) {
        Mail email = new Mail();
        email.setSubject(subject);
        email.setTextPart(message);
        email.setFrom(from);
        email.setTo(to);
        return this.sendMail(email);
    }

    @Override
    public int sendTextMessage(String from, String to, String cc, String bcc, String subject, String message, List<Attachment> attachments) {
        Mail email = new Mail();
        email.setSubject(subject);
        email.setTextPart(message);
        email.setFrom(from);
        email.setTo(to);
        email.setCc(cc);
        email.setBcc(bcc);
        email.setAttachments(attachments);
        return this.sendMail(email);
    }

    @Override
    public int sendRawMessage(String from, String to, String rawMessage) {
        Mail email = new Mail();
        email.setFrom(from);
        email.setTo(to);
        ((MailSenderPlugin)this.getProtectedPlugin()).parseRawMessage(rawMessage, email);
        return this.sendMail(email);
    }

    @Override
    public int sendMessageFromTemplate(String from, String to, String cc, String bcc, String language, String documentFullName, VelocityContext vcontext) {
        try {
            return ((MailSenderPlugin)this.getProtectedPlugin()).sendMailFromTemplate(documentFullName, from, to, cc, bcc, language, vcontext, this.context);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                this.context.put((Object)"error", (Object)e.getMessage());
            }
            LOGGER.error("sendMessageFromTemplate", (Throwable)e);
            return -1;
        }
    }

    public int sendMessageFromTemplate(String from, String to, String cc, String bcc, String language, String documentFullName, Map<String, Object> parameters) {
        try {
            return ((MailSenderPlugin)this.getProtectedPlugin()).sendMailFromTemplate(documentFullName, from, to, cc, bcc, language, parameters, this.context);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                this.context.put((Object)"error", (Object)e.getMessage());
            }
            LOGGER.error("sendMessageFromTemplate", (Throwable)e);
            return -1;
        }
    }

    @Override
    public Mail createMail() {
        return new Mail();
    }

    @Override
    public int sendMail(Mail mail) {
        int result = 0;
        try {
            ((MailSenderPlugin)this.getProtectedPlugin()).sendMail(mail, this.context);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                this.context.put((Object)"error", (Object)e.getMessage());
            }
            LOGGER.error("Failed to send email [" + mail.toString() + "]", (Throwable)e);
            result = -1;
        }
        return result;
    }

    @Override
    public MailConfiguration createMailConfiguration(XWiki xwiki) {
        return new MailConfiguration(xwiki);
    }

    @Override
    public int sendMail(Mail mail, MailConfiguration mailConfiguration) {
        int result = 0;
        try {
            ((MailSenderPlugin)this.getProtectedPlugin()).sendMail(mail, mailConfiguration, this.context);
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                this.context.put((Object)"error", (Object)e.getMessage());
            }
            LOGGER.error("Failed to send email [" + mail.toString() + "] using mail configuration [" + mailConfiguration.toString() + "]", (Throwable)e);
            result = -1;
        }
        return result;
    }
}

