/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.mailsender;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Api;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.api.Document;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.plugin.XWikiDefaultPlugin;
import com.xpn.xwiki.plugin.XWikiPluginInterface;
import com.xpn.xwiki.plugin.mailsender.Mail;
import com.xpn.xwiki.plugin.mailsender.MailConfiguration;
import com.xpn.xwiki.plugin.mailsender.MailSenderPluginApi;
import com.xpn.xwiki.plugin.mailsender.MimeTypesUtil;
import com.xpn.xwiki.util.Util;
import com.xpn.xwiki.web.ExternalServletURLFactory;
import com.xpn.xwiki.web.Utils;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.velocity.VelocityManager;

public class MailSenderPlugin
extends XWikiDefaultPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailSenderPlugin.class);
    private static final String EMAIL_ENCODING = "UTF-8";
    public static int ERROR_TEMPLATE_EMAIL_OBJECT_NOT_FOUND = -2;
    public static int ERROR = -1;
    public static final String EMAIL_XWIKI_CLASS_NAME = "XWiki.Mail";
    public static final String ID = "mailsender";
    protected static final String URL_SEPARATOR = "/";
    private static final Pattern SMTP_HEADER = Pattern.compile("^([\\x21-\\x7E&&[^\\x3A]]++):(.*+)$");
    private static final String SUBJECT = "Subject";
    private static final String FROM = "From";

    public MailSenderPlugin(String name, String className, XWikiContext context) {
        super(name, className, context);
    }

    public void init(XWikiContext context) {
        try {
            this.initMailClass(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void virtualInit(XWikiContext context) {
        try {
            this.initMailClass(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return ID;
    }

    public Api getPluginApi(XWikiPluginInterface plugin, XWikiContext context) {
        return new MailSenderPluginApi((MailSenderPlugin)plugin, context);
    }

    public static String[] parseAddresses(String email) {
        if (email == null) {
            return null;
        }
        email = email.trim();
        String[] emails = email.split(",");
        for (int i = 0; i < emails.length; ++i) {
            emails[i] = emails[i].trim();
        }
        return emails;
    }

    private static InternetAddress[] toInternetAddresses(String email) throws AddressException {
        String[] mails = MailSenderPlugin.parseAddresses(email);
        if (mails == null) {
            return null;
        }
        InternetAddress[] address = new InternetAddress[mails.length];
        for (int i = 0; i < mails.length; ++i) {
            address[i] = new InternetAddress(mails[i]);
        }
        return address;
    }

    protected BaseClass initMailClass(XWikiContext context) throws XWikiException {
        XWikiDocument doc;
        XWiki xwiki = context.getWiki();
        boolean needsUpdate = false;
        try {
            doc = xwiki.getDocument(EMAIL_XWIKI_CLASS_NAME, context);
        }
        catch (Exception e) {
            doc = new XWikiDocument();
            String[] spaceAndName = EMAIL_XWIKI_CLASS_NAME.split(".");
            doc.setSpace(spaceAndName[0]);
            doc.setName(spaceAndName[1]);
            needsUpdate = true;
        }
        BaseClass bclass = doc.getXClass();
        bclass.setName(EMAIL_XWIKI_CLASS_NAME);
        needsUpdate |= bclass.addTextField("subject", SUBJECT, 40);
        needsUpdate |= bclass.addTextField("language", "Language", 5);
        needsUpdate |= bclass.addTextAreaField("text", "Text", 80, 15);
        needsUpdate |= bclass.addTextAreaField("html", "HTML", 80, 15);
        if (StringUtils.isBlank((CharSequence)doc.getCreator())) {
            needsUpdate = true;
            doc.setCreator("superadmin");
        }
        if (StringUtils.isBlank((CharSequence)doc.getAuthor())) {
            needsUpdate = true;
            doc.setAuthor(doc.getCreator());
        }
        if (StringUtils.isBlank((CharSequence)doc.getParent())) {
            needsUpdate = true;
            doc.setParent("XWiki.XWikiClasses");
        }
        if (StringUtils.isBlank((CharSequence)doc.getTitle())) {
            needsUpdate = true;
            doc.setTitle("XWiki Mail Class");
        }
        if (StringUtils.isBlank((CharSequence)doc.getContent()) || !Syntax.XWIKI_2_0.equals((Object)doc.getSyntax())) {
            needsUpdate = true;
            doc.setContent("{{include reference=\"XWiki.ClassSheet\" /}}");
            doc.setSyntax(Syntax.XWIKI_2_0);
        }
        if (!doc.isHidden().booleanValue()) {
            needsUpdate = true;
            doc.setHidden(Boolean.valueOf(true));
        }
        if (needsUpdate) {
            xwiki.saveDocument(doc, context);
        }
        return bclass;
    }

    private MimeMessage createMimeMessage(Mail mail, Session session, XWikiContext context) throws MessagingException, XWikiException, IOException {
        InternetAddress from = new InternetAddress(mail.getFrom());
        String recipients = mail.getHeader("To");
        recipients = StringUtils.isBlank((CharSequence)recipients) ? mail.getTo() : mail.getTo() + "," + recipients;
        InternetAddress[] to = MailSenderPlugin.toInternetAddresses(recipients);
        recipients = mail.getHeader("Cc");
        recipients = StringUtils.isBlank((CharSequence)recipients) ? mail.getCc() : mail.getCc() + "," + recipients;
        InternetAddress[] cc = MailSenderPlugin.toInternetAddresses(recipients);
        recipients = mail.getHeader("Bcc");
        recipients = StringUtils.isBlank((CharSequence)recipients) ? mail.getBcc() : mail.getBcc() + "," + recipients;
        InternetAddress[] bcc = MailSenderPlugin.toInternetAddresses(recipients);
        if (to == null && cc == null && bcc == null) {
            LOGGER.info("No recipient -> skipping this email");
            return null;
        }
        MimeMessage message = new MimeMessage(session);
        message.setSentDate(new Date());
        message.setFrom((Address)from);
        if (to != null) {
            message.setRecipients(Message.RecipientType.TO, (Address[])to);
        }
        if (cc != null) {
            message.setRecipients(Message.RecipientType.CC, (Address[])cc);
        }
        if (bcc != null) {
            message.setRecipients(Message.RecipientType.BCC, (Address[])bcc);
        }
        message.setSubject(mail.getSubject(), EMAIL_ENCODING);
        for (Map.Entry<String, String> header : mail.getHeaders().entrySet()) {
            message.setHeader(header.getKey(), header.getValue());
        }
        if (mail.getHtmlPart() != null || mail.getAttachments() != null) {
            Multipart multipart = this.createMimeMultipart(mail, context);
            message.setContent(multipart);
        } else {
            message.setText(mail.getTextPart());
        }
        message.setSentDate(new Date());
        message.saveChanges();
        return message;
    }

    public MimeBodyPart createAttachmentBodyPart(Attachment attachment, XWikiContext context) throws XWikiException, IOException, MessagingException {
        String name = attachment.getFilename();
        byte[] stream = attachment.getContent();
        File temp = File.createTempFile("tmpfile", ".tmp");
        FileOutputStream fos = new FileOutputStream(temp);
        fos.write(stream);
        fos.close();
        FileDataSource source = new FileDataSource(temp);
        MimeBodyPart part = new MimeBodyPart();
        String mimeType = MimeTypesUtil.getMimeTypeFromFilename(name);
        part.setDataHandler(new DataHandler((DataSource)source));
        part.setHeader("Content-Type", mimeType);
        part.setFileName(name);
        part.setContentID("<" + name + ">");
        part.setDisposition("inline");
        temp.deleteOnExit();
        return part;
    }

    public Multipart createMimeMultipart(Mail mail, XWikiContext context) throws MessagingException, XWikiException, IOException {
        MimeMultipart multipart;
        ArrayList rawAttachments;
        ArrayList arrayList = rawAttachments = mail.getAttachments() != null ? mail.getAttachments() : new ArrayList();
        if (mail.getHtmlPart() == null && mail.getAttachments() != null) {
            multipart = new MimeMultipart("mixed");
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setContent((Object)mail.getTextPart(), "text/plain; charset=UTF-8");
            multipart.addBodyPart((BodyPart)textPart);
            for (Attachment attachment : rawAttachments) {
                multipart.addBodyPart((BodyPart)this.createAttachmentBodyPart(attachment, context));
            }
        } else {
            multipart = new MimeMultipart("mixed");
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            ArrayList<Attachment> embeddedImages = new ArrayList<Attachment>();
            MimeBodyPart textPart = new MimeBodyPart();
            textPart.setText(mail.getTextPart());
            MimeMultipart htmlMultipart = new MimeMultipart("related");
            MimeBodyPart htmlPart = new MimeBodyPart();
            htmlPart.setContent((Object)mail.getHtmlPart(), "text/html; charset=UTF-8");
            htmlPart.setHeader("Content-Disposition", "inline");
            htmlPart.setHeader("Content-Transfer-Encoding", "quoted-printable");
            htmlMultipart.addBodyPart((BodyPart)htmlPart);
            Pattern cidPattern = Pattern.compile("src=('|\")cid:([^'\"]*)('|\")", 10);
            Matcher matcher = cidPattern.matcher(mail.getHtmlPart());
            ArrayList<String> foundEmbeddedImages = new ArrayList<String>();
            while (matcher.find()) {
                foundEmbeddedImages.add(matcher.group(2));
            }
            for (Attachment attachment : rawAttachments) {
                if (foundEmbeddedImages.contains(attachment.getFilename())) {
                    embeddedImages.add(attachment);
                    continue;
                }
                attachments.add(attachment);
            }
            for (Attachment image : embeddedImages) {
                htmlMultipart.addBodyPart((BodyPart)this.createAttachmentBodyPart(image, context));
            }
            MimeMultipart alternativePart = new MimeMultipart("alternative");
            MimeBodyPart alternativeMultipartWrapper = new MimeBodyPart();
            MimeBodyPart htmlMultipartWrapper = new MimeBodyPart();
            alternativePart.addBodyPart((BodyPart)textPart);
            htmlMultipartWrapper.setContent((Multipart)htmlMultipart);
            alternativePart.addBodyPart((BodyPart)htmlMultipartWrapper);
            alternativeMultipartWrapper.setContent((Multipart)alternativePart);
            multipart.addBodyPart((BodyPart)alternativeMultipartWrapper);
            for (Attachment attachment : attachments) {
                multipart.addBodyPart((BodyPart)this.createAttachmentBodyPart(attachment, context));
            }
        }
        return multipart;
    }

    protected void parseRawMessage(String rawMessage, Mail toMail) {
        if (toMail == null) {
            throw new IllegalArgumentException("The target Mail can't be null");
        }
        if (rawMessage == null) {
            throw new IllegalArgumentException("rawMessage can't be null");
        }
        if (StringUtils.isBlank((CharSequence)rawMessage)) {
            throw new IllegalArgumentException("rawMessage can't be empty");
        }
        try {
            BufferedReader input = new BufferedReader(new StringReader(rawMessage));
            StringWriter result = new StringWriter();
            PrintWriter output = new PrintWriter(result);
            boolean headersFound = false;
            String line = input.readLine();
            Matcher m = SMTP_HEADER.matcher(line);
            while (line != null && m.matches()) {
                String header = m.group(1);
                String value = m.group(2);
                line = input.readLine();
                while (line != null && (line.startsWith(" ") || line.startsWith("\t"))) {
                    value = value + line;
                    line = input.readLine();
                }
                if (header.equals(SUBJECT)) {
                    toMail.setSubject(value);
                } else if (header.equals(FROM)) {
                    toMail.setFrom(value);
                } else {
                    toMail.setHeader(header, value);
                }
                if (line != null) {
                    m.reset(line);
                }
                headersFound = true;
            }
            if (headersFound && line != null && StringUtils.isBlank((CharSequence)line)) {
                line = input.readLine();
            } else if (headersFound) {
                LOGGER.warn("Mail body does not contain an empty line between the headers and the body.");
            }
            if (line == null) {
                toMail.setTextPart("");
                return;
            }
            do {
                output.print(line + "\r\n");
            } while ((line = input.readLine()) != null);
            toMail.setTextPart(result.toString());
        }
        catch (IOException ioe) {
            LOGGER.error("Unexpected IO exception while preparing a mail", (Throwable)ioe);
        }
    }

    protected String evaluate(String property, Context context) throws Exception {
        String value = (String)context.get(property);
        StringWriter stringWriter = new StringWriter();
        Velocity.evaluate((Context)context, (Writer)stringWriter, (String)property, (String)value);
        stringWriter.close();
        return stringWriter.toString();
    }

    protected String getFileName(String path) {
        return path.substring(path.lastIndexOf(URL_SEPARATOR) + 1);
    }

    private Properties initProperties(MailConfiguration mailConfiguration) {
        Properties properties = new Properties();
        properties.put("mail.smtp.port", Integer.toString(mailConfiguration.getPort()));
        properties.put("mail.smtp.host", mailConfiguration.getHost());
        properties.put("mail.smtp.localhost", "localhost");
        properties.put("mail.host", "localhost");
        properties.put("mail.debug", "false");
        if (mailConfiguration.getFrom() != null) {
            properties.put("mail.smtp.from", mailConfiguration.getFrom());
        }
        if (mailConfiguration.usesAuthentication()) {
            properties.put("mail.smtp.auth", "true");
        }
        mailConfiguration.appendExtraPropertiesTo(properties, true);
        return properties;
    }

    public VelocityContext prepareVelocityContext(String fromAddr, String toAddr, String ccAddr, String bccAddr, VelocityContext vcontext, XWikiContext context) {
        if (vcontext == null) {
            VelocityManager velocityManager = (VelocityManager)Utils.getComponent(VelocityManager.class);
            vcontext = new VelocityContext((Context)velocityManager.getVelocityContext());
        }
        vcontext.put("from.name", (Object)fromAddr);
        vcontext.put("from.address", (Object)fromAddr);
        vcontext.put("to.name", (Object)toAddr);
        vcontext.put("to.address", (Object)toAddr);
        vcontext.put("to.cc", (Object)ccAddr);
        vcontext.put("to.bcc", (Object)bccAddr);
        vcontext.put("bounce", (Object)fromAddr);
        return vcontext;
    }

    public VelocityContext prepareVelocityContext(String fromAddr, String toAddr, String ccAddr, String bccAddr, Map<String, Object> parameters, XWikiContext context) {
        VelocityManager velocityManager = (VelocityManager)Utils.getComponent(VelocityManager.class);
        VelocityContext vcontext = new VelocityContext((Context)velocityManager.getVelocityContext());
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                vcontext.put(entry.getKey(), entry.getValue());
            }
        }
        return vcontext;
    }

    public boolean sendMail(Mail mailItem, XWikiContext context) throws MessagingException, UnsupportedEncodingException {
        com.xpn.xwiki.api.XWiki xwikiApi = new com.xpn.xwiki.api.XWiki(context.getWiki(), context);
        return this.sendMail(mailItem, new MailConfiguration(xwikiApi), context);
    }

    public boolean sendMail(Mail mailItem, MailConfiguration mailConfiguration, XWikiContext context) throws MessagingException, UnsupportedEncodingException {
        ArrayList<Mail> mailList = new ArrayList<Mail>();
        mailList.add(mailItem);
        return this.sendMails(mailList, mailConfiguration, context);
    }

    public boolean sendMails(Collection<Mail> emails, XWikiContext context) throws MessagingException, UnsupportedEncodingException {
        com.xpn.xwiki.api.XWiki xwikiApi = new com.xpn.xwiki.api.XWiki(context.getWiki(), context);
        return this.sendMails(emails, new MailConfiguration(xwikiApi), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMails(Collection<Mail> emails, MailConfiguration mailConfiguration, XWikiContext context) throws MessagingException, UnsupportedEncodingException {
        Session session = null;
        Transport transport = null;
        int emailCount = emails.size();
        int count = 0;
        int sendFailedCount = 0;
        try {
            Iterator<Mail> emailIt = emails.iterator();
            while (emailIt.hasNext()) {
                ++count;
                Mail mail = emailIt.next();
                LOGGER.info("Sending email: " + mail.toString());
                if (transport == null || session == null) {
                    Properties props = this.initProperties(mailConfiguration);
                    session = Session.getInstance((Properties)props, null);
                    transport = session.getTransport("smtp");
                    if (!mailConfiguration.usesAuthentication()) {
                        transport.connect();
                    } else {
                        transport.connect(mailConfiguration.getSmtpUsername(), mailConfiguration.getSmtpPassword());
                    }
                }
                try {
                    MimeMessage message = this.createMimeMessage(mail, session, context);
                    if (message == null) continue;
                    transport.sendMessage((Message)message, message.getAllRecipients());
                    if (count % 100 != 0) continue;
                    try {
                        if (transport != null) {
                            transport.close();
                        }
                    }
                    catch (MessagingException ex) {
                        LOGGER.error("MessagingException has occured.", (Throwable)ex);
                    }
                    transport = null;
                    session = null;
                }
                catch (SendFailedException ex) {
                    ++sendFailedCount;
                    LOGGER.error("SendFailedException has occured.", (Throwable)ex);
                    LOGGER.error("Detailed email information" + mail.toString());
                    if (emailCount == 1) {
                        throw ex;
                    }
                    if (emailCount == 1 || sendFailedCount <= 10) continue;
                    throw ex;
                }
                catch (MessagingException mex) {
                    LOGGER.error("MessagingException has occured.", (Throwable)mex);
                    LOGGER.error("Detailed email information" + mail.toString());
                    if (emailCount != 1) continue;
                    throw mex;
                }
                catch (XWikiException e) {
                    LOGGER.error("XWikiException has occured.", (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error("IOException has occured.", (Throwable)e);
                }
            }
        }
        finally {
            try {
                if (transport != null) {
                    transport.close();
                }
            }
            catch (MessagingException ex) {
                LOGGER.error("MessagingException has occured.", (Throwable)ex);
            }
            LOGGER.info("sendEmails: Email count = " + emailCount + " sent count = " + count);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendMailFromTemplate(String templateDocFullName, String from, String to, String cc, String bcc, String language, VelocityContext vcontext, XWikiContext context) throws XWikiException {
        XWikiURLFactory originalURLFactory = context.getURLFactory();
        Locale originalLocale = context.getLocale();
        try {
            context.setURLFactory((XWikiURLFactory)new ExternalServletURLFactory(context));
            context.setLocale(LocaleUtils.toLocale((String)language));
            VelocityContext updatedVelocityContext = this.prepareVelocityContext(from, to, cc, bcc, vcontext, context);
            XWiki xwiki = context.getWiki();
            XWikiDocument doc = xwiki.getDocument(templateDocFullName, context);
            Document docApi = new Document(doc, context);
            BaseObject obj = doc.getObject(EMAIL_XWIKI_CLASS_NAME, "language", language);
            if (obj == null) {
                obj = doc.getObject(EMAIL_XWIKI_CLASS_NAME, "language", "en");
            }
            if (obj == null) {
                LOGGER.error("No mail object found in the document " + templateDocFullName);
                int n = ERROR_TEMPLATE_EMAIL_OBJECT_NOT_FOUND;
                return n;
            }
            String subjectContent = obj.getStringValue("subject");
            String txtContent = obj.getStringValue("text");
            String htmlContent = obj.getStringValue("html");
            String subject = this.evaluate(subjectContent, templateDocFullName, updatedVelocityContext, context);
            String msg = this.evaluate(txtContent, templateDocFullName, updatedVelocityContext, context);
            String html = this.evaluate(htmlContent, templateDocFullName, updatedVelocityContext, context);
            Mail mail = new Mail();
            mail.setFrom((String)updatedVelocityContext.get("from.address"));
            mail.setTo((String)updatedVelocityContext.get("to.address"));
            mail.setCc((String)updatedVelocityContext.get("to.cc"));
            mail.setBcc((String)updatedVelocityContext.get("to.bcc"));
            mail.setSubject(subject);
            mail.setTextPart(msg);
            mail.setHtmlPart(html);
            mail.setAttachments(docApi.getAttachmentList());
            try {
                this.sendMail(mail, context);
                int n = 0;
                return n;
            }
            catch (Exception e) {
                LOGGER.error("sendEmailFromTemplate: " + templateDocFullName + " vcontext: " + updatedVelocityContext, (Throwable)e);
                int n = ERROR;
                context.setURLFactory(originalURLFactory);
                context.setLocale(originalLocale);
                return n;
            }
        }
        finally {
            context.setURLFactory(originalURLFactory);
            context.setLocale(originalLocale);
        }
    }

    private String evaluate(String content, String name, VelocityContext vcontext, XWikiContext context) {
        StringWriter writer = new StringWriter();
        try {
            VelocityManager velocityManager = (VelocityManager)Utils.getComponent(VelocityManager.class);
            velocityManager.getVelocityEngine().evaluate((Context)vcontext, (Writer)writer, name, content);
            return writer.toString();
        }
        catch (Exception e) {
            LOGGER.error("Error while parsing velocity template namespace [{}]", (Object)name, (Object)e);
            Object[] args = new Object[]{name};
            XWikiException xe = new XWikiException(4, 4001, "Error while parsing velocity page {0}", (Throwable)e, args);
            return Util.getHTMLExceptionMessage((XWikiException)xe, (XWikiContext)context);
        }
    }

    public int sendMailFromTemplate(String templateDocFullName, String from, String to, String cc, String bcc, String language, Map<String, Object> parameters, XWikiContext context) throws XWikiException {
        VelocityContext vcontext = this.prepareVelocityContext(from, to, cc, bcc, parameters, context);
        return this.sendMailFromTemplate(templateDocFullName, from, to, cc, bcc, language, vcontext, context);
    }
}

