/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.messagestream.script;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.messagestream.MessageStream;
import org.xwiki.messagestream.MessageStreamConfiguration;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="messageStream")
@Singleton
public class MessageStreamScriptService
implements ScriptService {
    static final String ERROR_KEY = "scriptservice.messageStream.error";
    @Inject
    protected Execution execution;
    @Inject
    private MessageStream stream;
    @Inject
    private MessageStreamConfiguration messageStreamConfiguration;
    @Inject
    private DocumentAccessBridge documentAccessBridge;

    public boolean postPublicMessage(String message) {
        try {
            this.stream.postPublicMessage(message);
            return true;
        }
        catch (Exception e) {
            this.setError(e);
            return false;
        }
    }

    public boolean postPersonalMessage(String message) {
        try {
            this.stream.postPersonalMessage(message);
            return true;
        }
        catch (Exception e) {
            this.setError(e);
            return false;
        }
    }

    public boolean postDirectMessageToUser(String message, DocumentReference user) {
        try {
            this.stream.postDirectMessageToUser(message, user);
            return true;
        }
        catch (Exception e) {
            this.setError(e);
            return false;
        }
    }

    public boolean postMessageToGroup(String message, DocumentReference group) {
        try {
            this.stream.postMessageToGroup(message, group);
            return true;
        }
        catch (Exception e) {
            this.setError(e);
            return false;
        }
    }

    public boolean deleteMessage(String id) {
        try {
            this.stream.deleteMessage(id);
            return true;
        }
        catch (Exception e) {
            this.setError(e);
            return false;
        }
    }

    public boolean isActive() {
        return this.messageStreamConfiguration.isActive(this.documentAccessBridge.getCurrentDocumentReference().getWikiReference().getName());
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(ERROR_KEY);
    }

    protected void setError(Exception e) {
        this.execution.getContext().setProperty(ERROR_KEY, (Object)e);
    }
}

