/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.messagestream.internal;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventFactory;
import org.xwiki.eventstream.EventStream;
import org.xwiki.messagestream.MessageStream;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Singleton
public class DefaultMessageStream
implements MessageStream {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMessageStream.class);
    @Inject
    private QueryManager qm;
    @Inject
    private ModelContext context;
    @Inject
    @Named(value="current")
    private EntityReferenceResolver<String> currentResolver;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private EventStream stream;
    @Inject
    private EventFactory factory;
    @Inject
    private DocumentAccessBridge bridge;

    @Override
    public void postPublicMessage(String message) {
        Event e = this.createMessageEvent(message, "publicMessage");
        DocumentReference userDoc = new DocumentReference(this.currentResolver.resolve((Object)this.bridge.getCurrentUser(), EntityType.DOCUMENT, new Object[0]));
        e.setRelatedEntity((EntityReference)userDoc);
        e.setImportance(Event.Importance.MINOR);
        e.setStream((String)this.serializer.serialize((EntityReference)userDoc, new Object[0]));
        this.stream.addEvent(e);
    }

    @Override
    public void postPersonalMessage(String message) {
        Event e = this.createMessageEvent(message, "personalMessage");
        DocumentReference userDoc = new DocumentReference(this.currentResolver.resolve((Object)this.bridge.getCurrentUser(), EntityType.DOCUMENT, new Object[0]));
        e.setRelatedEntity((EntityReference)userDoc);
        e.setStream((String)this.serializer.serialize((EntityReference)userDoc, new Object[0]));
        this.stream.addEvent(e);
    }

    @Override
    public void postDirectMessageToUser(String message, DocumentReference user) {
        Event e = this.createMessageEvent(message, "directMessage");
        e.setRelatedEntity((EntityReference)new ObjectReference("XWiki.XWikiUsers", user));
        e.setStream((String)this.serializer.serialize((EntityReference)user, new Object[0]));
        e.setImportance(Event.Importance.CRITICAL);
        this.stream.addEvent(e);
    }

    @Override
    public void postMessageToGroup(String message, DocumentReference group) throws IllegalAccessError {
        Event e = this.createMessageEvent(message, "groupMessage");
        e.setRelatedEntity((EntityReference)new ObjectReference("XWiki.XWikiGroups", group));
        e.setStream((String)this.serializer.serialize((EntityReference)group, new Object[0]));
        e.setImportance(Event.Importance.MAJOR);
        this.stream.addEvent(e);
    }

    @Override
    public List<Event> getRecentPersonalMessages() {
        DocumentReference currentUser = new DocumentReference(this.currentResolver.resolve((Object)this.bridge.getCurrentUser(), EntityType.DOCUMENT, new Object[0]));
        return this.getRecentPersonalMessages(currentUser, 30, 0);
    }

    @Override
    public List<Event> getRecentPersonalMessages(int limit, int offset) {
        DocumentReference currentUser = new DocumentReference(this.currentResolver.resolve((Object)this.bridge.getCurrentUser(), EntityType.DOCUMENT, new Object[0]));
        return this.getRecentPersonalMessages(currentUser, limit, offset);
    }

    @Override
    public List<Event> getRecentPersonalMessages(DocumentReference author) {
        return this.getRecentPersonalMessages(author, 30, 0);
    }

    @Override
    public List<Event> getRecentPersonalMessages(DocumentReference author, int limit, int offset) {
        List<Object> result = new ArrayList<Event>();
        try {
            Query q = this.qm.createQuery("where event.application = 'MessageStream' and event.type = 'personalMessage' and event.user = :user order by event.date desc", "xwql");
            q.bindValue("user", this.serializer.serialize((EntityReference)author, new Object[0]));
            q.setLimit(limit > 0 ? limit : 30).setOffset(offset >= 0 ? offset : 0);
            result = this.stream.searchEvents(q);
        }
        catch (QueryException ex) {
            LOG.warn("Failed to search personal messages: {}", (Object)ex.getMessage());
        }
        return result;
    }

    @Override
    public List<Event> getRecentDirectMessages() {
        return this.getRecentDirectMessages(30, 0);
    }

    @Override
    public List<Event> getRecentDirectMessages(int limit, int offset) {
        List<Object> result = new ArrayList<Event>();
        try {
            DocumentReference currentUser = new DocumentReference(this.currentResolver.resolve((Object)this.bridge.getCurrentUser(), EntityType.DOCUMENT, new Object[0]));
            Query q = this.qm.createQuery("where event.application = 'MessageStream' and event.type = 'directMessage' and event.stream = :targetUser order by event.date desc", "xwql");
            q.bindValue("targetUser", this.serializer.serialize((EntityReference)currentUser, new Object[0]));
            q.setLimit(limit > 0 ? limit : 30).setOffset(offset >= 0 ? offset : 0);
            result = this.stream.searchEvents(q);
        }
        catch (QueryException ex) {
            LOG.warn("Failed to search direct messages: {}", (Object)ex.getMessage());
        }
        return result;
    }

    @Override
    public List<Event> getRecentMessagesForGroup(DocumentReference group) {
        return this.getRecentMessagesForGroup(group, 30, 0);
    }

    @Override
    public List<Event> getRecentMessagesForGroup(DocumentReference group, int limit, int offset) {
        List<Object> result = new ArrayList<Event>();
        try {
            Query q = this.qm.createQuery("where event.application = 'MessageStream' and event.type = 'groupMessage' and event.stream = :group order by event.date desc", "xwql");
            q.bindValue("group", this.serializer.serialize((EntityReference)group, new Object[0]));
            q.setLimit(limit > 0 ? limit : 30).setOffset(offset >= 0 ? offset : 0);
            result = this.stream.searchEvents(q);
        }
        catch (QueryException ex) {
            LOG.warn("Failed to search group messages: {}", (Object)ex.getMessage());
        }
        return result;
    }

    @Override
    public void deleteMessage(String id) {
        try {
            DocumentReference currentUser = new DocumentReference(this.currentResolver.resolve((Object)this.bridge.getCurrentUser(), EntityType.DOCUMENT, new Object[0]));
            Query q = this.qm.createQuery("where event.id = :id", "xwql");
            q.bindValue("id", (Object)id);
            List events = this.stream.searchEvents(q);
            if (events == null || events.isEmpty()) {
                throw new IllegalArgumentException("This message does not exist");
            }
            if (!((Event)events.get(0)).getUser().equals((Object)currentUser)) {
                throw new IllegalArgumentException("You are not authorized to delete this message");
            }
            this.stream.deleteEvent((Event)events.get(0));
        }
        catch (QueryException ex) {
            LOG.warn("Failed to delete message: {}", (Object)ex.getMessage());
        }
    }

    protected Event createMessageEvent(String message, String messageType) {
        Event e = this.factory.createEvent();
        e.setApplication("MessageStream");
        e.setDocument(new DocumentReference(this.context.getCurrentEntityReference().getRoot().getName(), "XWiki", e.getId()));
        e.setBody(StringUtils.left((String)message, (int)2000));
        e.setType(messageType);
        return e;
    }
}

