/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.properties.converter.AbstractConverter;

@Component
@Singleton
public class AttachmentReferenceConverter
extends AbstractConverter<AttachmentReference> {
    @Inject
    @Named(value="current")
    private AttachmentReferenceResolver<String> stringResolver;
    @Inject
    @Named(value="current")
    private AttachmentReferenceResolver<EntityReference> referenceResolver;
    @Inject
    @Named(value="compact")
    private EntityReferenceSerializer<String> serializer;

    protected AttachmentReference convertToType(Type type, Object value) {
        if (value == null) {
            return null;
        }
        AttachmentReference reference = value instanceof EntityReference ? this.referenceResolver.resolve((EntityReference)value, new Object[0]) : this.stringResolver.resolve(value.toString(), new Object[0]);
        return reference;
    }

    protected String convertToString(AttachmentReference value) {
        if (value == null) {
            return null;
        }
        return this.serializer.serialize(value, new Object[0]);
    }
}

