/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.validation.internal;

import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.validation.AbstractEntityNameValidation;

@Component
@Singleton
@Named(value="SlugEntityNameValidation")
public class SlugEntityNameValidation
extends AbstractEntityNameValidation {
    protected static final String COMPONENT_NAME = "SlugEntityNameValidation";
    private static final Pattern VALIDATION_PATTERN = Pattern.compile("^([\\w]+[-]?[\\w]+)+$");
    private static final String REPLACEMENT_CHARACTER = "-";

    public String transform(String name) {
        String strippedAccents = StringUtils.stripAccents((String)name);
        String result = RegExUtils.replaceAll((String)strippedAccents, (String)"[\\W]", (String)REPLACEMENT_CHARACTER);
        if ((result = RegExUtils.replaceAll((String)result, (String)"[-]+", (String)REPLACEMENT_CHARACTER)).endsWith(REPLACEMENT_CHARACTER)) {
            result = result.substring(0, result.length() - 1);
        }
        if (result.startsWith(REPLACEMENT_CHARACTER)) {
            result = result.substring(1);
        }
        return result;
    }

    public boolean isValid(String name) {
        return VALIDATION_PATTERN.matcher(name).matches();
    }
}

