/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.model.internal.reference;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.SpaceReference;

/**
 * Provide a complete reference based on configurable default wiki, spaces and document.
 * 
 * @version $Id: 144eae2d19d8787d3d39211cab89beea10358ef3 $
 * @since 7.2M1
 */
@Component
@Singleton
public class DefaultDocumentReferenceProvider implements Provider<DocumentReference>
{
    @Inject
    private EntityReferenceProvider provider;

    @Inject
    private Provider<SpaceReference> spaceReferenceProvider;

    @Inject
    private EntityReferenceFactory factory;

    /**
     * We can cache the default document since it's configurable only at xwiki.properties level which require a restart
     * to be modified.
     */
    private DocumentReference cachedReference;

    @Override
    public DocumentReference get()
    {
        if (this.cachedReference == null) {
            EntityReference reference = this.provider.getDefaultReference(EntityType.DOCUMENT);

            // Add spaces
            reference = reference.appendParent(this.spaceReferenceProvider.get());

            this.cachedReference = this.factory.getReference(new DocumentReference(reference));
        }

        return this.cachedReference;
    }
}
