/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.util.List;
import java.util.Locale;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AbstractLocalizedEntityReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.PageReference;
import org.xwiki.stability.Unstable;

@Unstable
public class LocalPageReference
extends AbstractLocalizedEntityReference {
    public LocalPageReference(String pageName, String ... pageNames) {
        this(PageReference.toList(pageName, pageNames));
    }

    public LocalPageReference(List<String> pageNames) {
        this(pageNames.get(pageNames.size() - 1), (EntityReference)(pageNames.size() > 1 ? new LocalPageReference(pageNames.subList(0, pageNames.size() - 1)) : null));
    }

    public LocalPageReference(String pageName, Locale locale) {
        super(pageName, EntityType.PAGE, locale);
    }

    public LocalPageReference(EntityReference reference) {
        super(reference);
    }

    public LocalPageReference(EntityReference entityReference, Locale locale) {
        super(entityReference, locale);
    }

    public LocalPageReference(String pageName, EntityReference pageReference) {
        super(pageName, EntityType.PAGE, pageReference);
    }

    public LocalPageReference(PageReference pageReference) {
        super(pageReference, pageReference.getWikiReference(), null);
    }

    @Override
    protected void setParent(EntityReference parent) {
        if (parent != null && parent.getType() != EntityType.PAGE) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] in a local page reference");
        }
        super.setParent(parent != null ? new LocalPageReference(parent) : null);
    }

    @Override
    protected void setType(EntityType type) {
        if (type != EntityType.PAGE) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for a page reference");
        }
        super.setType(type);
    }

    @Override
    public String toString() {
        return TOSTRING_SERIALIZER.serialize(this, new Object[0]);
    }
}

