/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectPropertyReference;

public class BlockReference
extends EntityReference {
    public BlockReference(EntityReference reference) {
        super(reference);
    }

    protected BlockReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        super(reference, oldReference, newReference);
    }

    public BlockReference(String blockName) {
        super(blockName, EntityType.BLOCK);
    }

    public BlockReference(String blockName, DocumentReference documentReference) {
        super(blockName, EntityType.BLOCK, (EntityReference)documentReference);
    }

    public BlockReference(String blockName, ObjectPropertyReference objectPropertyReference) {
        super(blockName, EntityType.BLOCK, (EntityReference)objectPropertyReference);
    }

    public BlockReference(EntityReference reference, EntityReference parent) {
        super(reference, parent);
    }

    @Override
    protected void setType(EntityType type) {
        if (type != EntityType.BLOCK) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for a block reference");
        }
        super.setType(EntityType.BLOCK);
    }

    @Override
    protected void setParent(EntityReference parent) {
        if (parent == null || parent instanceof DocumentReference || parent instanceof ObjectPropertyReference) {
            super.setParent(parent);
            return;
        }
        if (parent.getType() != EntityType.DOCUMENT && parent.getType() != EntityType.OBJECT_PROPERTY) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] in a block reference");
        }
        if (parent.getType() == EntityType.DOCUMENT) {
            super.setParent(new DocumentReference(parent));
        } else {
            super.setParent(new ObjectPropertyReference(parent));
        }
    }

    @Override
    public BlockReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        if (newParent == oldParent) {
            return this;
        }
        return new BlockReference(this, oldParent, newParent);
    }

    @Override
    public BlockReference replaceParent(EntityReference newParent) {
        if (newParent == this.getParent()) {
            return this;
        }
        return new BlockReference((EntityReference)this, newParent);
    }
}

