/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.model.internal.reference;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;

import org.xwiki.model.EntityType;

/**
 * Some constants related to {@link org.xwiki.model.reference.EntityReference}.
 *
 * @version $Id: 2b8b7871125904e5b4b933e6219c9715bb4ff105 $
 * @since 8.1M2
 */
public interface EntityReferenceConstants
{
    /**
     * The hierarchy of Entity Types.
     * 
     * @deprecated since 10.6RC1, use {@link EntityType#getAllowedParents()} instead
     */
    @Deprecated
    Map<EntityType, List<EntityType>> PARENT_TYPES = new EnumMap<EntityType, List<EntityType>>(EntityType.class)
    {
        {
            for (EntityType type : EntityType.values()) {
                put(type, type.getAllowedParents());
            }
        }
    };
}
