/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;

public abstract class AbstractStringEntityReferenceResolver
implements EntityReferenceResolver<String> {
    private static final Map<EntityType, char[]> SEPARATORS = new HashMap<EntityType, char[]>(){
        {
            this.put(EntityType.DOCUMENT, new char[]{'.', ':'});
            this.put(EntityType.ATTACHMENT, new char[]{'@', '.', ':'});
            this.put(EntityType.SPACE, new char[]{':'});
            this.put(EntityType.OBJECT, new char[]{'^', '.', ':'});
            this.put(EntityType.OBJECT_PROPERTY, new char[]{'.', '^', '.', ':'});
            this.put(EntityType.CLASS_PROPERTY, new char[]{'^', '.', ':'});
        }
    };
    private static final Map<EntityType, EntityType[]> ENTITYTYPES = new HashMap<EntityType, EntityType[]>(){
        {
            this.put(EntityType.DOCUMENT, new EntityType[]{EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.ATTACHMENT, new EntityType[]{EntityType.ATTACHMENT, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.SPACE, new EntityType[]{EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.OBJECT, new EntityType[]{EntityType.OBJECT, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.OBJECT_PROPERTY, new EntityType[]{EntityType.OBJECT_PROPERTY, EntityType.OBJECT, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
            this.put(EntityType.CLASS_PROPERTY, new EntityType[]{EntityType.CLASS_PROPERTY, EntityType.DOCUMENT, EntityType.SPACE, EntityType.WIKI});
        }
    };
    private static final String[] ESCAPEMATCHING = new String[]{"\\\\", "\\"};
    private static final String[] ESCAPEMATCHINGREPLACE = new String[]{"\\", ""};

    protected abstract String getDefaultValue(EntityType var1, Object ... var2);

    @Override
    public EntityReference resolve(String entityReferenceRepresentation, EntityType type, Object ... parameters) {
        if (!SEPARATORS.containsKey((Object)type)) {
            throw new RuntimeException("No parsing definition found for Entity Type [" + (Object)((Object)type) + "]");
        }
        StringBuilder representation = entityReferenceRepresentation == null ? new StringBuilder() : new StringBuilder(entityReferenceRepresentation);
        EntityReference reference = null;
        EntityReference lastReference = null;
        char[] separatorsForType = SEPARATORS.get((Object)type);
        EntityType[] entityTypesForType = ENTITYTYPES.get((Object)type);
        for (int i = 0; i < separatorsForType.length; ++i) {
            String name;
            if (representation.length() > 0) {
                char separator = separatorsForType[i];
                name = this.lastIndexOf(representation, separator, entityTypesForType[i], parameters);
            } else {
                name = this.resolveDefaultValue(entityTypesForType[i], parameters);
            }
            if (name == null) continue;
            EntityReference newReference = new EntityReference(name, entityTypesForType[i]);
            if (lastReference != null) {
                lastReference.setParent(newReference);
            }
            lastReference = newReference;
            if (reference != null) continue;
            reference = lastReference;
        }
        String name = representation.length() > 0 ? StringUtils.replaceEach((String)representation.toString(), (String[])ESCAPEMATCHING, (String[])ESCAPEMATCHINGREPLACE) : this.resolveDefaultValue(entityTypesForType[separatorsForType.length], parameters);
        if (name != null) {
            EntityReference newReference = new EntityReference(name, entityTypesForType[separatorsForType.length]);
            if (lastReference != null) {
                lastReference.setParent(newReference);
            }
            if (reference == null) {
                reference = newReference;
            }
        }
        return reference;
    }

    private String lastIndexOf(StringBuilder representation, char separator, EntityType entityType, Object ... parameters) {
        String name = null;
        boolean found = false;
        for (int i = representation.length() - 1; i >= 0; --i) {
            char currentChar = representation.charAt(i);
            int nextIndex = i - 1;
            char nextChar = '\u0000';
            if (nextIndex >= 0) {
                nextChar = representation.charAt(nextIndex);
            }
            if (currentChar == separator) {
                int numberOfBackslashes = this.getNumberOfCharsBefore('\\', representation, nextIndex);
                if (numberOfBackslashes % 2 == 0) {
                    name = i == representation.length() - 1 ? this.resolveDefaultValue(entityType, parameters) : representation.substring(i + 1, representation.length());
                    representation.delete(i, representation.length());
                    found = true;
                    break;
                }
                representation.delete(nextIndex, i);
                --i;
                continue;
            }
            if (nextChar != '\\') continue;
            representation.delete(nextIndex, i);
            --i;
        }
        if (!found) {
            name = representation.toString();
            representation.setLength(0);
        }
        return name;
    }

    private int getNumberOfCharsBefore(char c, StringBuilder representation, int currentPosition) {
        int position;
        for (position = currentPosition; position >= 0 && representation.charAt(position) == c; --position) {
        }
        return currentPosition - position;
    }

    private String resolveDefaultValue(EntityType type, Object ... parameters) {
        EntityReference referenceParameter;
        EntityReference extractedReference;
        String resolvedDefaultValue = null;
        if (parameters.length > 0 && parameters[0] instanceof EntityReference && (extractedReference = (referenceParameter = (EntityReference)parameters[0]).extractReference(type)) != null) {
            resolvedDefaultValue = extractedReference.getName();
        }
        if (resolvedDefaultValue == null) {
            resolvedDefaultValue = this.getDefaultValue(type, parameters);
        }
        return resolvedDefaultValue;
    }
}

