/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.util.regex.Pattern;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;

public class RegexEntityReference
extends EntityReference {
    private Pattern pattern;

    public RegexEntityReference(Pattern pattern, EntityType type) {
        super(pattern.pattern(), type);
        this.pattern = pattern;
    }

    public RegexEntityReference(Pattern pattern, EntityType type, EntityReference parent) {
        super(pattern.pattern(), type, parent);
        this.pattern = pattern;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public boolean equals(Object obj) {
        EntityReference reference;
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityReference)) {
            return false;
        }
        for (EntityReference entity = reference = (EntityReference)obj; entity != null; entity = entity.getParent()) {
            if (!this.getType().equals((Object)entity.getType())) continue;
            if (this.pattern != null && !this.pattern.matcher(entity.getName()).matches()) {
                return false;
            }
            return this.getParent() != null ? this.getParent().equals(entity) : true;
        }
        return true;
    }
}

