/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.script;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.EntityReferenceValueProvider;
import org.xwiki.model.reference.ObjectPropertyReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.script.service.ScriptService;
import org.xwiki.stability.Unstable;

@Component
@Named(value="model")
@Singleton
public class ModelScriptService
implements ScriptService {
    private static final String DEFAULT_RESOLVER_HINT = "current";
    private static final String DEFAULT_SERIALIZER_HINT = "compact";
    @Inject
    private Logger logger;
    @Inject
    private ComponentManager componentManager;

    public DocumentReference createDocumentReference(String wiki, String space, String page) {
        return this.createDocumentReference(wiki, space, page, DEFAULT_RESOLVER_HINT);
    }

    public DocumentReference createDocumentReference(String wiki, String space, String page, String hint) {
        DocumentReference documentReference;
        EntityReference reference = null;
        if (!StringUtils.isEmpty((CharSequence)wiki)) {
            reference = new EntityReference(wiki, EntityType.WIKI);
        }
        if (!StringUtils.isEmpty((CharSequence)space)) {
            reference = new EntityReference(space, EntityType.SPACE, reference);
        }
        if (!StringUtils.isEmpty((CharSequence)page)) {
            reference = new EntityReference(page, EntityType.DOCUMENT, reference);
        }
        try {
            DocumentReferenceResolver resolver = (DocumentReferenceResolver)this.componentManager.getInstance((Type)DocumentReferenceResolver.TYPE_REFERENCE, hint);
            documentReference = resolver.resolve(reference, new Object[0]);
        }
        catch (ComponentLookupException e) {
            try {
                DocumentReferenceResolver drr = (DocumentReferenceResolver)this.componentManager.getInstance(DocumentReferenceResolver.class, hint);
                documentReference = drr.resolve(reference, new Object[0]);
                this.logger.warn("Deprecated usage of DocumentReferenceResolver with hint [{}]. Please consider using a DocumentReferenceResolver that takes into account generic types.", (Object)hint);
            }
            catch (ComponentLookupException ex) {
                documentReference = null;
            }
        }
        return documentReference;
    }

    public AttachmentReference createAttachmentReference(DocumentReference documentReference, String fileName) {
        return new AttachmentReference(fileName, documentReference);
    }

    @Unstable
    public WikiReference createWikiReference(String wikiName) {
        return new WikiReference(wikiName);
    }

    @Unstable
    public SpaceReference createSpaceReference(String spaceName, WikiReference parent) {
        return new SpaceReference(spaceName, parent);
    }

    @Unstable
    public EntityReference createEntityReference(String name, EntityType type) {
        return new EntityReference(name, type);
    }

    @Unstable
    public EntityReference createEntityReference(String name, EntityType type, EntityReference parent) {
        return new EntityReference(name, type, parent);
    }

    @Unstable
    public SpaceReference resolveSpace(String stringRepresentation, Object ... parameters) {
        return this.resolveSpace(stringRepresentation, DEFAULT_RESOLVER_HINT, parameters);
    }

    @Unstable
    public SpaceReference resolveSpace(String stringRepresentation, String hint, Object ... parameters) {
        try {
            EntityReferenceResolver resolver = (EntityReferenceResolver)this.componentManager.getInstance((Type)EntityReferenceResolver.TYPE_STRING, hint);
            return new SpaceReference(resolver.resolve(stringRepresentation, EntityType.SPACE, parameters));
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    public DocumentReference resolveDocument(String stringRepresentation, Object ... parameters) {
        return this.resolveDocument(stringRepresentation, DEFAULT_RESOLVER_HINT, parameters);
    }

    public DocumentReference resolveDocument(String stringRepresentation, String hint, Object ... parameters) {
        try {
            EntityReferenceResolver resolver = (EntityReferenceResolver)this.componentManager.getInstance((Type)EntityReferenceResolver.TYPE_STRING, hint);
            return new DocumentReference(resolver.resolve(stringRepresentation, EntityType.DOCUMENT, parameters));
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    public AttachmentReference resolveAttachment(String stringRepresentation, Object ... parameters) {
        return this.resolveAttachment(stringRepresentation, DEFAULT_RESOLVER_HINT, parameters);
    }

    public AttachmentReference resolveAttachment(String stringRepresentation, String hint, Object ... parameters) {
        try {
            EntityReferenceResolver resolver = (EntityReferenceResolver)this.componentManager.getInstance((Type)EntityReferenceResolver.TYPE_STRING, hint);
            return new AttachmentReference(resolver.resolve(stringRepresentation, EntityType.ATTACHMENT, parameters));
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    public ObjectReference resolveObject(String stringRepresentation, Object ... parameters) {
        return this.resolveObject(stringRepresentation, DEFAULT_RESOLVER_HINT, parameters);
    }

    public ObjectReference resolveObject(String stringRepresentation, String hint, Object ... parameters) {
        try {
            EntityReferenceResolver resolver = (EntityReferenceResolver)this.componentManager.getInstance((Type)EntityReferenceResolver.TYPE_STRING, hint);
            return new ObjectReference(resolver.resolve(stringRepresentation, EntityType.OBJECT, parameters));
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    public ObjectPropertyReference resolveObjectProperty(String stringRepresentation, Object ... parameters) {
        return this.resolveObjectProperty(stringRepresentation, DEFAULT_RESOLVER_HINT, parameters);
    }

    public ObjectPropertyReference resolveObjectProperty(String stringRepresentation, String hint, Object ... parameters) {
        try {
            EntityReferenceResolver resolver = (EntityReferenceResolver)this.componentManager.getInstance((Type)EntityReferenceResolver.TYPE_STRING, hint);
            return new ObjectPropertyReference(resolver.resolve(stringRepresentation, EntityType.OBJECT_PROPERTY, parameters));
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    public String serialize(EntityReference reference, Object ... parameters) {
        return this.serialize(reference, DEFAULT_SERIALIZER_HINT, parameters);
    }

    public String serialize(EntityReference reference, String hint, Object ... parameters) {
        String result;
        try {
            EntityReferenceSerializer serializer = (EntityReferenceSerializer)this.componentManager.getInstance((Type)EntityReferenceSerializer.TYPE_STRING, hint);
            result = (String)serializer.serialize(reference, parameters);
        }
        catch (ComponentLookupException e) {
            result = null;
        }
        return result;
    }

    public String getEntityReferenceValue(EntityType type) {
        return this.getEntityReferenceValue(type, DEFAULT_RESOLVER_HINT);
    }

    public String getEntityReferenceValue(EntityType type, String hint) {
        if (type == null) {
            return null;
        }
        try {
            EntityReferenceValueProvider provider = (EntityReferenceValueProvider)this.componentManager.getInstance(EntityReferenceValueProvider.class, hint);
            return provider.getDefaultValue(type);
        }
        catch (ComponentLookupException ex) {
            return null;
        }
    }
}

