/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.AbstractEntityReferenceResolver;
import org.xwiki.model.internal.reference.StringReferenceSeparators;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;

public abstract class AbstractStringEntityReferenceResolver
extends AbstractEntityReferenceResolver
implements EntityReferenceResolver<String> {
    private static final String[] ESCAPEMATCHING = new String[]{StringReferenceSeparators.DBLESCAPE, StringReferenceSeparators.ESCAPE};
    private static final String[] ESCAPEMATCHINGREPLACE = new String[]{StringReferenceSeparators.ESCAPE, ""};

    @Override
    public EntityReference resolve(String entityReferenceRepresentation, EntityType type, Object ... parameters) {
        EntityType parentType;
        Map<Character, EntityType> typeSetup = this.getTypeSetup(type);
        if (typeSetup == null) {
            return this.getEscapedReference(entityReferenceRepresentation, type, parameters);
        }
        StringBuilder representation = entityReferenceRepresentation == null ? new StringBuilder() : new StringBuilder(entityReferenceRepresentation);
        EntityReference reference = null;
        EntityType currentType = type;
        do {
            parentType = null;
            int i = representation.length();
            while (--i >= 0) {
                char currentChar = representation.charAt(i);
                int nextIndex = i - 1;
                char nextChar = '\u0000';
                if (nextIndex >= 0) {
                    nextChar = representation.charAt(nextIndex);
                }
                if (typeSetup.containsKey(Character.valueOf(currentChar))) {
                    int numberOfBackslashes = this.getNumberOfCharsBefore('\\', representation, nextIndex);
                    if (numberOfBackslashes % 2 == 0) {
                        parentType = typeSetup.get(Character.valueOf(currentChar));
                        break;
                    }
                    representation.delete(nextIndex, i);
                    --i;
                    continue;
                }
                if (nextChar != '\\') continue;
                representation.delete(nextIndex, i);
                --i;
            }
            reference = this.appendNewReference(reference, this.getNewReference(i, representation, currentType, parameters));
        } while ((typeSetup = this.getTypeSetup(currentType = parentType != null ? parentType : typeSetup.values().iterator().next())) != null);
        reference = this.appendNewReference(reference, this.getEscapedReference(representation, currentType, parameters));
        return reference;
    }

    protected Map<Character, EntityType> getTypeSetup(EntityType type) {
        return StringReferenceSeparators.REFERENCE_SETUP.get((Object)type);
    }

    private EntityReference getEscapedReference(CharSequence representation, EntityType type, Object ... parameters) {
        String name;
        EntityReference newReference = representation.length() > 0 ? ((name = StringUtils.replaceEach((String)representation.toString(), (String[])ESCAPEMATCHING, (String[])ESCAPEMATCHINGREPLACE)) != null ? new EntityReference(name, type) : null) : this.resolveDefaultReference(type, parameters);
        return newReference;
    }

    private EntityReference getNewReference(int i, StringBuilder representation, EntityType type, Object ... parameters) {
        EntityReference newReference;
        if (i == representation.length() - 1) {
            newReference = this.resolveDefaultReference(type, parameters);
        } else {
            String name = representation.substring(i + 1, representation.length());
            newReference = new EntityReference(name, type);
        }
        representation.delete(i < 0 ? 0 : i, representation.length());
        return newReference;
    }

    private EntityReference appendNewReference(EntityReference reference, EntityReference newReference) {
        if (newReference != null) {
            if (reference != null) {
                return reference.appendParent(newReference);
            }
            return newReference;
        }
        return reference;
    }

    private int getNumberOfCharsBefore(char c, StringBuilder representation, int currentPosition) {
        int position;
        for (position = currentPosition; position >= 0 && representation.charAt(position) == c; --position) {
        }
        return currentPosition - position;
    }
}

