/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.internal.reference.AbstractStringEntityReferenceSerializer;
import org.xwiki.model.reference.EntityReference;

@Component
@Named(value="path")
@Singleton
public class PathStringEntityReferenceSerializer
extends AbstractStringEntityReferenceSerializer {
    @Override
    protected void serializeEntityReference(EntityReference currentReference, StringBuilder representation, boolean isLastReference, Object ... parameters) {
        if (currentReference.getParent() != null) {
            representation.append('/');
        }
        try {
            representation.append(URLEncoder.encode(currentReference.getName(), "UTF-8").replace(".", "%2E").replace("*", "%2A"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not present on the system!", e);
        }
    }
}

