/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.notifications;

import org.xwiki.stability.Unstable;

/**
 * The different formats for notifications.
 *
 * @version $Id: 9782cc8ab5272fc4ff32df6b839630c962ab7c30 $
 * @since 9.5RC1
 */
@Unstable
public enum NotificationFormat
{
    /**
     * Notification displayed in the UI (as an "alert").
     */
    ALERT,

    /**
     * Notification sent by email.
     */
    EMAIL
}
