/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStatus;
import org.xwiki.eventstream.EventStatusManager;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.CompositeEventStatus;
import org.xwiki.notifications.CompositeEventStatusManager;

@Component
@Singleton
public class DefaultCompositeEventStatusManager
implements CompositeEventStatusManager {
    @Inject
    private EventStatusManager eventStatusManager;

    @Override
    public List<CompositeEventStatus> getCompositeEventStatuses(List<CompositeEvent> compositeEvents, String entityId) throws Exception {
        ArrayList<Event> allEvents = new ArrayList<Event>();
        HashMap<String, CompositeEventStatus> map = new HashMap<String, CompositeEventStatus>();
        for (CompositeEvent compositeEvent : compositeEvents) {
            CompositeEventStatus compositeEventStatus = new CompositeEventStatus(compositeEvent);
            for (Event event : compositeEvent.getEvents()) {
                map.put(event.getId(), compositeEventStatus);
            }
            allEvents.addAll(compositeEvent.getEvents());
        }
        for (EventStatus eventStatus : this.getEventStatuses(allEvents, entityId)) {
            ((CompositeEventStatus)map.get(eventStatus.getEvent().getId())).add(eventStatus);
        }
        ArrayList<CompositeEventStatus> results = new ArrayList<CompositeEventStatus>();
        for (CompositeEvent event : compositeEvents) {
            results.add((CompositeEventStatus)map.get(event.getEvents().get(0).getId()));
        }
        return results;
    }

    private List<EventStatus> getEventStatuses(List<Event> events, String entityId) throws Exception {
        return this.eventStatusManager.getEventStatus(events, Arrays.asList(entityId));
    }
}

