/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.component.namespace.NamespaceContextExecutor;
import org.xwiki.model.namespace.WikiNamespace;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.NotificationDisplayer;
import org.xwiki.notifications.notifiers.NotificationRenderer;
import org.xwiki.rendering.block.Block;
import org.xwiki.text.StringUtils;

@Component
@Singleton
public class DefaultNotificationRenderer
implements NotificationRenderer {
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private NamespaceContextExecutor namespaceContextExecutor;
    @Inject
    private NotificationDisplayer defaultDisplayer;

    @Override
    public Block render(CompositeEvent event) throws NotificationException {
        try {
            if (event.getDocument() != null) {
                return (Block)this.namespaceContextExecutor.execute((Namespace)new WikiNamespace(event.getDocument().getWikiReference().getName()), () -> this.renderCompositeEvent(event));
            }
            return this.renderCompositeEvent(event);
        }
        catch (Exception e) {
            throw new NotificationException("Failed to render the notification.", (Throwable)e);
        }
    }

    private Block renderCompositeEvent(CompositeEvent event) throws Exception {
        return this.getDisplayer(event).renderNotification(event);
    }

    private NotificationDisplayer getDisplayer(CompositeEvent event) throws ComponentLookupException {
        for (NotificationDisplayer displayer : this.componentManager.getInstanceList(NotificationDisplayer.class)) {
            for (String supportedEvent : displayer.getSupportedEvents()) {
                if (!StringUtils.equals((CharSequence)supportedEvent, (CharSequence)event.getType())) continue;
                return displayer;
            }
        }
        return this.defaultDisplayer;
    }
}

