/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email.live;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.context.concurrent.ExecutionContextRunnable;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.RecordableEventDescriptor;
import org.xwiki.eventstream.RecordableEventDescriptorManager;
import org.xwiki.eventstream.events.EventStreamAddedEvent;
import org.xwiki.notifications.NotificationConfiguration;
import org.xwiki.notifications.notifiers.internal.email.live.LiveNotificationEmailManager;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.RemoteObservationManagerContext;

@Component
@Singleton
@Named(value="Live Notification Email Listener")
public class LiveNotificationEmailListener
extends AbstractEventListener {
    public static final String NAME = "Live Notification Email Listener";
    @Inject
    private RecordableEventDescriptorManager recordableEventDescriptorManager;
    @Inject
    private LiveNotificationEmailManager liveNotificationEmailManager;
    @Inject
    private NotificationConfiguration notificationConfiguration;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    private RemoteObservationManagerContext remoteState;
    @Inject
    private Logger logger;
    private Thread notificationGraceTimeThread;

    public LiveNotificationEmailListener() {
        super(NAME, new Event[]{new EventStreamAddedEvent()});
    }

    public void onEvent(Event event, Object o, Object o1) {
        if (!this.remoteState.isRemoteState() && this.notificationConfiguration.isEnabled() && this.notificationConfiguration.areEmailsEnabled()) {
            try {
                org.xwiki.eventstream.Event eventStreamEvent = (org.xwiki.eventstream.Event)o;
                List descriptorList = this.recordableEventDescriptorManager.getRecordableEventDescriptors(true);
                for (RecordableEventDescriptor descriptor : descriptorList) {
                    if (!descriptor.getEventType().equals(eventStreamEvent.getType())) continue;
                    this.liveNotificationEmailManager.addEvent(eventStreamEvent);
                    this.startNotificationThread();
                }
            }
            catch (EventStreamException e) {
                this.logger.warn("Unable to retrieve a full list of RecordableEventDescriptor.", (Throwable)e);
            }
        }
    }

    private synchronized void startNotificationThread() {
        if (this.notificationGraceTimeThread == null || !this.notificationGraceTimeThread.isAlive() && this.notificationGraceTimeThread.getState() != Thread.State.NEW) {
            this.notificationGraceTimeThread = new Thread((Runnable)new ExecutionContextRunnable((Runnable)new NotificationGraceTimeRunnable(), this.componentManager));
            this.notificationGraceTimeThread.setName("Live E-Mail notifications thread");
            this.notificationGraceTimeThread.setDaemon(true);
            this.notificationGraceTimeThread.setPriority(4);
        }
        if (!this.notificationGraceTimeThread.isAlive()) {
            this.notificationGraceTimeThread.start();
        }
    }

    private class NotificationGraceTimeRunnable
    implements Runnable {
        private NotificationGraceTimeRunnable() {
        }

        @Override
        public void run() {
            DateTime nextWakeUpTime = DateTime.now();
            while (nextWakeUpTime != null) {
                block4: {
                    if (nextWakeUpTime.isAfterNow()) {
                        try {
                            Thread.sleep(nextWakeUpTime.getMillis() - DateTime.now().getMillis());
                        }
                        catch (IllegalArgumentException | InterruptedException e) {
                            if (!(e instanceof InterruptedException)) break block4;
                            return;
                        }
                    }
                }
                LiveNotificationEmailListener.this.liveNotificationEmailManager.run();
                nextWakeUpTime = LiveNotificationEmailListener.this.liveNotificationEmailManager.getNextExecutionDate();
            }
        }
    }
}

