/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.rss;

import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.feed.synd.SyndFeedImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.internal.ModelBridge;
import org.xwiki.notifications.notifiers.rss.NotificationRSSManager;
import org.xwiki.notifications.notifiers.rss.NotificationRSSRenderer;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultNotificationRSSManager
implements NotificationRSSManager {
    @Inject
    private ContextualLocalizationManager contextualLocalizationManager;
    @Inject
    private ModelBridge modelBridge;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private NotificationRSSRenderer defaultNotificationRSSRenderer;
    @Inject
    private Logger logger;

    @Override
    public SyndFeed renderFeed(List<CompositeEvent> events) {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setTitle(this.contextualLocalizationManager.getTranslationPlain("notifications.rss.feedTitle", new Object[0]));
        feed.setLink(this.modelBridge.getDocumentURL(new DocumentReference(this.wikiDescriptorManager.getCurrentWikiId(), Arrays.asList("XWiki", "Notifications", "Code"), "NotificationRSSService"), "get", "outputSyntax=plain"));
        feed.setDescription(this.contextualLocalizationManager.getTranslationPlain("notifications.rss.feedDescription", new Object[0]));
        ArrayList<SyndEntry> entries = new ArrayList<SyndEntry>();
        for (CompositeEvent event : events) {
            try {
                NotificationRSSRenderer renderer = this.getRenderer(event);
                if (renderer != null) {
                    entries.add(renderer.renderNotification(event));
                    continue;
                }
                entries.add(this.defaultNotificationRSSRenderer.renderNotification(event));
            }
            catch (NotificationException e) {
                this.logger.warn("Unable to render RSS entry for CompositeEvent [{}] : [{}]", (Object)event, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        feed.setEntries(entries);
        return feed;
    }

    protected NotificationRSSRenderer getRenderer(CompositeEvent event) {
        if (this.componentManager.hasComponent(NotificationRSSRenderer.class, event.getType())) {
            try {
                return (NotificationRSSRenderer)this.componentManager.getInstance(NotificationRSSRenderer.class, event.getType());
            }
            catch (ComponentLookupException e) {
                this.logger.error("Unable to fetch NotificationRSSRenderer component with hint [{}]", (Object)event.getType(), (Object)e);
            }
        }
        return null;
    }
}

