/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.script;

import com.rometools.rome.io.SyndFeedOutput;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.NotificationRenderer;
import org.xwiki.notifications.notifiers.rss.NotificationRSSManager;
import org.xwiki.notifications.sources.NotificationManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="notification.notifiers")
@Singleton
public class NotificationNotifiersScriptService
implements ScriptService {
    @Inject
    private NotificationRenderer notificationRenderer;
    @Inject
    private NotificationRSSManager notificationRSSManager;
    @Inject
    private NotificationManager notificationManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;

    public Block render(CompositeEvent event) throws NotificationException {
        return this.notificationRenderer.render(event);
    }

    public String getFeed(int entryNumber) throws NotificationException {
        String userId = (String)this.entityReferenceSerializer.serialize((EntityReference)this.documentAccessBridge.getCurrentUserReference(), new Object[0]);
        return this.getFeed(userId, entryNumber);
    }

    public String getFeed(String userId, int entryNumber) throws NotificationException {
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            return output.outputString(this.notificationRSSManager.renderFeed(this.notificationManager.getEvents(userId, entryNumber)));
        }
        catch (Exception e) {
            throw new NotificationException("Unable to render RSS feed", (Throwable)e);
        }
    }
}

