/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal;

import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;
import org.xwiki.text.StringUtils;

public abstract class AbstractWikiNotificationRenderer
implements WikiComponent {
    protected static final String EVENT_BINDING_NAME = "event";
    protected TemplateManager templateManager;
    protected ScriptContextManager scriptContextManager;
    protected ComponentManager componentManager;
    protected BaseObjectReference objectReference;
    protected DocumentReference authorReference;
    protected String eventType;

    public AbstractWikiNotificationRenderer(DocumentReference authorReference, TemplateManager templateManager, ScriptContextManager scriptContextManager, ComponentManager componentManager, BaseObject baseObject) throws NotificationException {
        this.objectReference = (BaseObjectReference)baseObject.getReference();
        this.authorReference = authorReference;
        this.templateManager = templateManager;
        this.scriptContextManager = scriptContextManager;
        this.componentManager = componentManager;
        this.eventType = this.extractProperty(baseObject, "eventType");
    }

    protected Template extractTemplate(BaseObject baseObject, String propertyName) throws NotificationException {
        try {
            String xObjectTemplate = this.extractProperty(baseObject, propertyName);
            if (StringUtils.isNotBlank((CharSequence)xObjectTemplate)) {
                return this.templateManager.createStringTemplate(xObjectTemplate, this.getAuthorReference());
            }
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Unable to render the template provided in the base object [%s]", baseObject), (Throwable)e);
        }
        return null;
    }

    protected String extractProperty(BaseObject baseObject, String propertyName) throws NotificationException {
        try {
            return baseObject.getStringValue(propertyName);
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Unable to extract the parameter [%s] from the [%s] NotificationDisplayerClass.", propertyName, baseObject), (Throwable)e);
        }
    }

    public DocumentReference getDocumentReference() {
        return (DocumentReference)this.objectReference.getParent();
    }

    public EntityReference getEntityReference() {
        return this.objectReference;
    }

    public DocumentReference getAuthorReference() {
        return this.authorReference;
    }

    public String getRoleHint() {
        return this.eventType;
    }

    public WikiComponentScope getScope() {
        return WikiComponentScope.WIKI;
    }
}

