/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.internal.ModelBridge;

@Component
@Singleton
public class DefaultModelBridge
implements ModelBridge {
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;

    public void savePropertyInHiddenDocument(BaseObjectReference objectReference, String property, Object value) throws NotificationException {
        try {
            XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
            DocumentReference documentReference = (DocumentReference)objectReference.getParent();
            XWikiDocument doc = xcontext.getWiki().getDocument(documentReference, xcontext);
            doc.setHidden(Boolean.valueOf(true));
            BaseObject obj = doc.getObject((String)this.entityReferenceSerializer.serialize((EntityReference)objectReference.getXClassReference(), new Object[0]), true, xcontext);
            if (obj != null) {
                obj.set(property, value, xcontext);
                doc.setMetaDataDirty(false);
                doc.setContentDirty(false);
                xcontext.getWiki().saveDocument(doc, String.format("Property [%s] set.", property), xcontext);
            }
        }
        catch (XWikiException e) {
            throw new NotificationException(String.format("Failed to update the object [%s].", objectReference), (Throwable)e);
        }
    }

    public String getDocumentURL(DocumentReference documentReference, String action, String parameters) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        return context.getWiki().getExternalURL(documentReference, action, parameters, null, context);
    }
}

