/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.email.NotificationEmailRenderer;
import org.xwiki.notifications.notifiers.internal.email.AbstractNotificationEmailRenderer;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.text.StringUtils;

@Component
@Singleton
public class DefaultNotificationEmailRenderer
extends AbstractNotificationEmailRenderer {
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;

    private NotificationEmailRenderer getRenderer(CompositeEvent event) {
        try {
            return (NotificationEmailRenderer)this.componentManager.getInstance(NotificationEmailRenderer.class, event.getType());
        }
        catch (ComponentLookupException e) {
            return null;
        }
    }

    public String renderHTML(CompositeEvent event, String userId) throws NotificationException {
        String result;
        NotificationEmailRenderer renderer = this.getRenderer(event);
        if (renderer != null && StringUtils.isNotBlank((CharSequence)(result = renderer.renderHTML(event, userId)))) {
            return result;
        }
        return this.renderHTML(this.executeTemplate(event, userId, "notification/email/%s.html.vm", Syntax.XHTML_1_0));
    }

    public String renderPlainText(CompositeEvent event, String userId) throws NotificationException {
        String result;
        NotificationEmailRenderer renderer = this.getRenderer(event);
        if (renderer != null && StringUtils.isNotBlank((CharSequence)(result = renderer.renderPlainText(event, userId)))) {
            return result;
        }
        return this.renderPlainText(this.executeTemplate(event, userId, "notification/email/%s.plain.vm", Syntax.PLAIN_1_0));
    }

    public String generateEmailSubject(CompositeEvent event, String userId) throws NotificationException {
        String result;
        NotificationEmailRenderer renderer = this.getRenderer(event);
        if (renderer != null && StringUtils.isNotBlank((CharSequence)(result = renderer.generateEmailSubject(event, userId)))) {
            return result;
        }
        return this.renderPlainText(this.executeTemplate(event, userId, "notification/email/%s.subject.vm", Syntax.PLAIN_1_0));
    }
}

