/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;

@Component
@Named(value="R1130000WatchlistLeftoversCleaner")
@Singleton
public class WatchlistLeftoversCleaner
extends AbstractHibernateDataMigration {
    private static final String SCHEDULER_SPACE_NAME = "Scheduler";
    private static final String XWIKI_SPACE = "XWiki";
    private static final List<LocalDocumentReference> DOCUMENTS_TO_REMOVE = Arrays.asList(new LocalDocumentReference("Scheduler", "WatchListDailyNotifier"), new LocalDocumentReference("Scheduler", "WatchListHourlyNotifier"), new LocalDocumentReference("Scheduler", "WatchListWeeklyNotifier"), new LocalDocumentReference("XWiki", "WatchListClass"), new LocalDocumentReference("XWiki", "WatchListJobClass"));
    @Inject
    private Logger logger;

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        XWikiContext context = this.getXWikiContext();
        this.logger.info("Starting WatchlistLeftoversCleaner on wiki [{}].", (Object)context.getWikiId());
        try {
            XWiki xwiki = context.getWiki();
            for (LocalDocumentReference documentToRemove : DOCUMENTS_TO_REMOVE) {
                XWikiDocument document = xwiki.getDocument((EntityReference)documentToRemove, context);
                if (document.isNew()) continue;
                xwiki.deleteDocument(document, context);
            }
        }
        catch (Exception e) {
            throw new DataMigrationException("Failed to remove watchlist leftovers.", (Throwable)e);
        }
        this.logger.info("End of WatchlistLeftoversCleaner on wiki [{}].", (Object)context.getWikiId());
    }

    public String getDescription() {
        return "Remove some mandatory documents created by the Watchlist Application that the notification email notifier replaces.";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(1130000);
    }
}

