/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.codec.digest.DigestUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.filters.expression.AndNode;
import org.xwiki.notifications.filters.expression.BooleanValueNode;
import org.xwiki.notifications.filters.expression.ConcatNode;
import org.xwiki.notifications.filters.expression.DateValueNode;
import org.xwiki.notifications.filters.expression.EndsWith;
import org.xwiki.notifications.filters.expression.EntityReferenceNode;
import org.xwiki.notifications.filters.expression.EqualsNode;
import org.xwiki.notifications.filters.expression.EventProperty;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.filters.expression.GreaterThanNode;
import org.xwiki.notifications.filters.expression.InNode;
import org.xwiki.notifications.filters.expression.InSubQueryNode;
import org.xwiki.notifications.filters.expression.LesserThanNode;
import org.xwiki.notifications.filters.expression.NotEqualsNode;
import org.xwiki.notifications.filters.expression.NotNode;
import org.xwiki.notifications.filters.expression.OrNode;
import org.xwiki.notifications.filters.expression.PropertyValueNode;
import org.xwiki.notifications.filters.expression.StartsWith;
import org.xwiki.notifications.filters.expression.StringValueNode;
import org.xwiki.notifications.filters.expression.generics.AbstractBinaryOperatorNode;
import org.xwiki.notifications.filters.expression.generics.AbstractOperatorNode;
import org.xwiki.notifications.filters.expression.generics.AbstractUnaryOperatorNode;
import org.xwiki.notifications.filters.expression.generics.AbstractValueNode;
import org.xwiki.notifications.filters.internal.status.InListOfReadEventsNode;
import org.xwiki.notifications.sources.internal.OrderByNode;

@Component(roles={ExpressionNodeToHQLConverter.class})
@Singleton
public class ExpressionNodeToHQLConverter {
    private static final String VARIABLE_NAME = ":%s";
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public HQLQuery parse(ExpressionNode node) {
        HQLQuery result = new HQLQuery();
        result.query = this.parseBlock(node, result);
        return result;
    }

    private String parseBlock(ExpressionNode node, HQLQuery result) {
        if (node instanceof AbstractValueNode) {
            return this.parseValue((AbstractValueNode)node, result);
        }
        if (node instanceof AbstractUnaryOperatorNode) {
            return this.parseUnaryOperator((AbstractUnaryOperatorNode)node, result);
        }
        if (node instanceof AbstractBinaryOperatorNode) {
            return this.parseBinaryOperator((AbstractBinaryOperatorNode)node, result);
        }
        if (node instanceof AbstractOperatorNode) {
            return this.parseOtherOperation((AbstractOperatorNode)node, result);
        }
        return "";
    }

    private String parseValue(AbstractValueNode value, HQLQuery result) {
        return this.parseValue(value, false, result);
    }

    private String parseValue(AbstractValueNode value, boolean escape, HQLQuery result) {
        String returnValue;
        if (value instanceof PropertyValueNode) {
            switch ((EventProperty)((PropertyValueNode)value).getContent()) {
                case ID: {
                    returnValue = "event.id";
                    break;
                }
                case GROUP_ID: {
                    returnValue = "event.requestId";
                    break;
                }
                case STREAM: {
                    returnValue = "event.stream";
                    break;
                }
                case DATE: {
                    returnValue = "event.date";
                    break;
                }
                case APPLICATION: {
                    returnValue = "event.application";
                    break;
                }
                case BODY: {
                    returnValue = "event.body";
                    break;
                }
                case TYPE: {
                    returnValue = "event.type";
                    break;
                }
                case HIDDEN: {
                    returnValue = "event.hidden";
                    break;
                }
                case PAGE: {
                    returnValue = "event.page";
                    break;
                }
                case IMPORTANCE: {
                    returnValue = "event.priority";
                    break;
                }
                case SPACE: {
                    returnValue = "event.space";
                    break;
                }
                case TITLE: {
                    returnValue = "event.title";
                    break;
                }
                case USER: {
                    returnValue = "event.user";
                    break;
                }
                case WIKI: {
                    returnValue = "event.wiki";
                    break;
                }
                case URL: {
                    returnValue = "event.url";
                    break;
                }
                case DOCUMENT_VERSION: {
                    returnValue = "event.version";
                    break;
                }
                default: {
                    returnValue = "";
                    break;
                }
            }
        } else if (value instanceof StringValueNode) {
            StringValueNode valueNode = (StringValueNode)value;
            String nodeContent = escape ? this.escape((String)valueNode.getContent()) : (String)valueNode.getContent();
            String mapKey = String.format("value_%s", DigestUtils.sha256Hex((String)((String)valueNode.getContent())));
            result.queryParameters.put(mapKey, nodeContent);
            returnValue = String.format(VARIABLE_NAME, mapKey);
        } else if (value instanceof EntityReferenceNode) {
            String stringValue = (String)this.serializer.serialize((EntityReference)((EntityReferenceNode)value).getContent(), new Object[0]);
            if (escape) {
                stringValue = this.escape(stringValue);
            }
            String mapKey = String.format("entity_%s", DigestUtils.sha256Hex((String)stringValue));
            result.queryParameters.put(mapKey, stringValue);
            returnValue = String.format(VARIABLE_NAME, mapKey);
        } else if (value instanceof DateValueNode) {
            DateValueNode dateValueNode = (DateValueNode)value;
            String stringValue = ((Date)dateValueNode.getContent()).toString();
            String mapKey = String.format("date_%s", DigestUtils.sha256Hex((String)stringValue));
            result.queryParameters.put(mapKey, dateValueNode.getContent());
            returnValue = String.format(VARIABLE_NAME, mapKey);
        } else if (value instanceof BooleanValueNode) {
            returnValue = ((Boolean)((BooleanValueNode)value).getContent()).toString();
        } else if (value instanceof ConcatNode) {
            ConcatNode node = (ConcatNode)value;
            returnValue = String.format("CONCAT(%s, %s)", this.parseBlock((ExpressionNode)node.getLeftOperand(), result), this.parseBlock((ExpressionNode)node.getRightOperand(), result));
        } else {
            returnValue = "";
        }
        return returnValue;
    }

    private String parseUnaryOperator(AbstractUnaryOperatorNode operator, HQLQuery result) {
        if (operator instanceof NotNode) {
            return String.format(" NOT (%s)", this.parseBlock((ExpressionNode)operator.getOperand(), result));
        }
        return "";
    }

    private String parseBinaryOperator(AbstractBinaryOperatorNode operator, HQLQuery result) {
        String returnValue = operator instanceof AndNode ? String.format("(%s) AND (%s)", this.parseBlock((ExpressionNode)operator.getLeftOperand(), result), this.parseBlock((ExpressionNode)operator.getRightOperand(), result)) : (operator instanceof OrNode ? String.format("(%s) OR (%s)", this.parseBlock((ExpressionNode)operator.getLeftOperand(), result), this.parseBlock((ExpressionNode)operator.getRightOperand(), result), result) : (operator instanceof EqualsNode ? String.format("%s = %s", this.parseValue((AbstractValueNode)operator.getLeftOperand(), result), this.parseValue((AbstractValueNode)operator.getRightOperand(), result)) : (operator instanceof NotEqualsNode ? String.format("%s <> %s", this.parseValue((AbstractValueNode)operator.getLeftOperand(), result), this.parseValue((AbstractValueNode)operator.getRightOperand(), result)) : (operator instanceof StartsWith ? String.format("%s LIKE concat(%s, '%%') ESCAPE '!'", this.parseValue((AbstractValueNode)operator.getLeftOperand(), result), this.parseValue((AbstractValueNode)operator.getRightOperand(), true, result)) : (operator instanceof EndsWith ? String.format("%s LIKE concat('%%', %s) ESCAPE '!'", this.parseValue((AbstractValueNode)operator.getLeftOperand(), result), this.parseValue((AbstractValueNode)operator.getRightOperand(), true, result)) : (operator instanceof GreaterThanNode ? String.format("%s >= %s", this.parseBlock((ExpressionNode)operator.getLeftOperand(), result), this.parseBlock((ExpressionNode)operator.getRightOperand(), result)) : (operator instanceof LesserThanNode ? String.format("%s <= %s", this.parseBlock((ExpressionNode)operator.getLeftOperand(), result), this.parseBlock((ExpressionNode)operator.getRightOperand(), result)) : "")))))));
        return returnValue;
    }

    private String parseOtherOperation(AbstractOperatorNode operator, HQLQuery result) {
        String returnValue;
        if (operator instanceof InNode) {
            InNode inOperator = (InNode)operator;
            StringBuilder builder = new StringBuilder(this.parseBlock((ExpressionNode)inOperator.getLeftOperand(), result));
            builder.append(" IN (");
            String separator = "";
            for (AbstractValueNode value : inOperator.getValues()) {
                builder.append(separator);
                builder.append(this.parseBlock((ExpressionNode)value, result));
                separator = ", ";
            }
            builder.append(")");
            returnValue = builder.toString();
        } else if (operator instanceof InSubQueryNode) {
            InSubQueryNode inSubQueryOperator = (InSubQueryNode)operator;
            StringBuilder builder = new StringBuilder(this.parseBlock((ExpressionNode)inSubQueryOperator.getLeftOperand(), result));
            builder.append(" IN (");
            builder.append(inSubQueryOperator.getSubQuery());
            builder.append(")");
            returnValue = builder.toString();
            result.getQueryParameters().putAll(inSubQueryOperator.getParameters());
        } else if (operator instanceof OrderByNode) {
            OrderByNode orderByNode = (OrderByNode)operator;
            returnValue = String.format("%s ORDER BY %s %s", this.parseBlock((ExpressionNode)orderByNode.getQuery(), result), this.parseBlock((ExpressionNode)orderByNode.getProperty(), result), orderByNode.getOrder().name());
        } else if (operator instanceof InListOfReadEventsNode) {
            InListOfReadEventsNode inList = (InListOfReadEventsNode)operator;
            returnValue = String.format("event IN (select status.activityEvent from LegacyEventStatus status where status.activityEvent = event and status.entityId = :userStatusRead and status.read = true)", new Object[0]);
            result.getQueryParameters().put("userStatusRead", this.serializer.serialize((EntityReference)inList.getUser(), new Object[0]));
        } else {
            returnValue = "";
        }
        return returnValue;
    }

    private String escape(String format) {
        return format.replaceAll("([%_!])", "!$1");
    }

    public static final class HQLQuery {
        private String query;
        private Map<String, Object> queryParameters = new HashMap<String, Object>();

        public String getQuery() {
            return this.query;
        }

        public Map<String, Object> getQueryParameters() {
            return this.queryParameters;
        }
    }
}

