/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.script;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.sources.NotificationManager;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="notification.sources")
@Singleton
public class NotificationSourcesScriptService
implements ScriptService {
    @Inject
    private NotificationManager notificationManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;

    public List<CompositeEvent> getEvents(int expectedCount) throws NotificationException {
        return this.notificationManager.getEvents((String)this.entityReferenceSerializer.serialize((EntityReference)this.documentAccessBridge.getCurrentUserReference(), new Object[0]), expectedCount);
    }

    public List<CompositeEvent> getEvents(int expectedCount, Date untilDate, String[] blackList) throws NotificationException {
        return this.notificationManager.getEvents((String)this.entityReferenceSerializer.serialize((EntityReference)this.documentAccessBridge.getCurrentUserReference(), new Object[0]), expectedCount, untilDate, Arrays.asList(blackList));
    }

    public List<CompositeEvent> getEvents(int expectedCount, Date untilDate, List<String> blackList) throws NotificationException {
        return this.notificationManager.getEvents((String)this.entityReferenceSerializer.serialize((EntityReference)this.documentAccessBridge.getCurrentUserReference(), new Object[0]), expectedCount, untilDate, blackList);
    }

    public long getEventsCount(int maxCount) throws NotificationException {
        return this.notificationManager.getEventsCount((String)this.entityReferenceSerializer.serialize((EntityReference)this.documentAccessBridge.getCurrentUserReference(), new Object[0]), maxCount);
    }
}

