/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.Requirement;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.event.ComponentDescriptorAddedEvent;
import org.xwiki.component.event.ComponentDescriptorEvent;
import org.xwiki.component.event.ComponentDescriptorRemovedEvent;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.AllEvent;
import org.xwiki.observation.event.Event;

@Component
public class DefaultObservationManager
implements ObservationManager,
Initializable {
    private Map<Class<? extends Event>, Map<String, RegisteredListener>> listenersByEvent = new ConcurrentHashMap<Class<? extends Event>, Map<String, RegisteredListener>>();
    private Map<String, EventListener> listenersByName = new ConcurrentHashMap<String, EventListener>();
    @Requirement
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    public void initialize() throws InitializationException {
        try {
            for (EventListener listener : this.componentManager.lookupList(EventListener.class)) {
                this.addListener(listener);
            }
        }
        catch (ComponentLookupException e) {
            throw new InitializationException("Failed to lookup Event Listeners", (Throwable)e);
        }
    }

    public void addListener(EventListener eventListener) {
        EventListener previousListener = this.listenersByName.put(eventListener.getName(), eventListener);
        if (previousListener != null) {
            this.logger.warn("The [" + eventListener.getClass().getName() + "] listener has overwritten a previously " + "registered listener [" + previousListener.getClass().getName() + "] since they both are registered under the same id [" + eventListener.getName() + "]." + " In the future consider removing a Listener first if you really want to register it again.");
        }
        for (Event event : eventListener.getEvents()) {
            Map<String, RegisteredListener> eventListeners = this.listenersByEvent.get(event.getClass());
            if (eventListeners == null) {
                eventListeners = new ConcurrentHashMap<String, RegisteredListener>();
                this.listenersByEvent.put(event.getClass(), eventListeners);
                eventListeners.put(eventListener.getName(), new RegisteredListener(eventListener, event));
                continue;
            }
            RegisteredListener registeredListener = eventListeners.get(eventListener.getName());
            if (registeredListener == null) {
                eventListeners.put(eventListener.getName(), new RegisteredListener(eventListener, event));
                continue;
            }
            registeredListener.addEvent(event);
        }
    }

    public void removeListener(String listenerName) {
        this.listenersByName.remove(listenerName);
        for (Map.Entry<Class<? extends Event>, Map<String, RegisteredListener>> entry : this.listenersByEvent.entrySet()) {
            entry.getValue().remove(listenerName);
            if (!entry.getValue().isEmpty()) continue;
            this.listenersByEvent.remove(entry.getKey());
        }
    }

    public void addEvent(String listenerName, Event event) {
        Map<String, RegisteredListener> listeners = this.listenersByEvent.get(event.getClass());
        RegisteredListener listener = listeners.get(listenerName);
        if (listener != null) {
            listener.addEvent(event);
        }
    }

    public void removeEvent(String listenerName, Event event) {
        Map<String, RegisteredListener> listeners = this.listenersByEvent.get(event.getClass());
        RegisteredListener listener = listeners.get(listenerName);
        if (listener != null) {
            listener.removeEvent(event);
        }
    }

    public EventListener getListener(String listenerName) {
        return this.listenersByName.get(listenerName);
    }

    public void notify(Event event, Object source, Object data) {
        Map<String, RegisteredListener> allEventRegListeners;
        Map<String, RegisteredListener> regListeners = this.listenersByEvent.get(event.getClass());
        if (regListeners != null) {
            this.notify(regListeners.values(), event, source, data);
        }
        if ((allEventRegListeners = this.listenersByEvent.get(AllEvent.class)) != null) {
            this.notify(allEventRegListeners.values(), event, source, data);
        }
        if (event instanceof ComponentDescriptorEvent) {
            this.onComponentEvent((ComponentDescriptorEvent)event, (ComponentDescriptor<EventListener>)((ComponentDescriptor)data));
        }
    }

    private void notify(Collection<RegisteredListener> listeners, Event event, Object source, Object data) {
        block2: for (RegisteredListener listener : listeners) {
            for (Event listenerEvent : listener.events) {
                if (!listenerEvent.matches((Object)event)) continue;
                try {
                    listener.listener.onEvent(event, source, data);
                }
                catch (Exception e) {
                    this.logger.error("Fail to send event [" + event + "] to listener [" + listener.listener + "]", (Throwable)e);
                }
                continue block2;
            }
        }
    }

    public void notify(Event event, Object source) {
        this.notify(event, source, null);
    }

    private void onComponentEvent(ComponentDescriptorEvent componentEvent, ComponentDescriptor<EventListener> data) {
        if (componentEvent.getRole() == EventListener.class) {
            if (componentEvent instanceof ComponentDescriptorAddedEvent) {
                this.componentAdded((ComponentDescriptorAddedEvent)componentEvent, data);
            } else {
                this.componentRemoved((ComponentDescriptorRemovedEvent)componentEvent, data);
            }
        }
    }

    private void componentAdded(ComponentDescriptorAddedEvent event, ComponentDescriptor<EventListener> descriptor) {
        try {
            EventListener eventListener = (EventListener)this.componentManager.lookup(EventListener.class, event.getRoleHint());
            if (this.getListener(eventListener.getName()) != eventListener) {
                this.addListener(eventListener);
            }
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup event listener corresponding to the component registration event", (Throwable)e);
        }
    }

    private void componentRemoved(ComponentDescriptorRemovedEvent event, ComponentDescriptor<?> descriptor) {
        EventListener removedEventListener = null;
        for (EventListener eventListener : this.listenersByName.values()) {
            if (eventListener.getClass() != descriptor.getImplementation()) continue;
            removedEventListener = eventListener;
        }
        if (removedEventListener != null) {
            this.removeListener(removedEventListener.getName());
        }
    }

    private static class RegisteredListener {
        private List<Event> events = new ArrayList<Event>();
        private EventListener listener;

        RegisteredListener(EventListener listener, Event event) {
            this.addEvent(event);
            this.listener = listener;
        }

        void addEvent(Event event) {
            this.events.add(event);
        }

        void removeEvent(Event event) {
            this.events.remove(event);
        }
    }
}

