/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.remote.internal;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.AllEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.RemoteObservationManager;
import org.xwiki.observation.remote.RemoteObservationManagerConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Named(value="observation.remote")
@Singleton
public class LocalEventListener
extends AbstractLogEnabled
implements EventListener {
    private static final String NAME = "observation.remote";
    @Inject
    private RemoteObservationManagerConfiguration configuration;
    @Inject
    private ComponentManager componentManager;
    private RemoteObservationManager remoteObservationManager;

    public List<Event> getEvents() {
        List<Object> events = this.configuration.isEnabled() ? Collections.singletonList(AllEvent.ALLEVENT) : Collections.emptyList();
        return events;
    }

    public String getName() {
        return NAME;
    }

    public void onEvent(Event event, Object source, Object data) {
        if (this.remoteObservationManager == null) {
            try {
                this.remoteObservationManager = (RemoteObservationManager)this.componentManager.lookup(RemoteObservationManager.class);
            }
            catch (ComponentLookupException e) {
                this.getLogger().error("Failed to initialize the Remote Observation Manager", (Throwable)e);
            }
        }
        this.remoteObservationManager.notify(new LocalEventData(event, source, data));
    }
}

