/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.remote.internal.jgroups;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.logging.AbstractLogEnabled;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.RemoteObservationManager;
import org.xwiki.observation.remote.jgroups.JGroupsReceiver;

@Component
@Singleton
public class DefaultJGroupsReceiver
extends AbstractLogEnabled
implements JGroupsReceiver {
    private RemoteObservationManager remoteObservationManager;
    @Inject
    private ComponentManager componentManager;
    private Address address;

    public RemoteObservationManager getRemoteObservationManager() {
        if (this.remoteObservationManager == null) {
            try {
                this.remoteObservationManager = (RemoteObservationManager)this.componentManager.lookup(RemoteObservationManager.class);
            }
            catch (ComponentLookupException e) {
                this.getLogger().error("Failed to lookup the Remote Observation Manager.", (Throwable)e);
            }
        }
        return this.remoteObservationManager;
    }

    public byte[] getState() {
        return null;
    }

    public void receive(Message msg) {
        if (this.address == null || !this.address.equals(msg.getSrc())) {
            RemoteEventData remoteEvent = (RemoteEventData)msg.getObject();
            this.getLogger().debug("Received JGroups remote event [" + remoteEvent + "]");
            this.getRemoteObservationManager().notify(remoteEvent);
        }
    }

    public void setState(byte[] state) {
    }

    public void block() {
    }

    public void suspect(Address suspectedMbr) {
    }

    public void viewAccepted(View newView) {
    }
}

